local AceLocale = LibStub:GetLibrary("AceLocale-3.0")
local L = AceLocale:NewLocale("Raven", "zhCN")
if not L then return end

-- Main.lua
L["Raven"] = true
L["Raven left click"] = "点击|cffffff00左键|r 以 打开/关闭配置菜单"
L["Raven right click"] = "点击|cffffff00右键|r 以 锁定/解锁所有计时条组"
L["Raven shift left click"] = "|cffffff00Shift+左键|r 以 启用/禁用 Raven"
L["Raven shift right click"] = "|cffffff00Shift+右键|r 以 显示/隐藏系统默认BUFF"
L["Shared Potion Cooldown"] = "共享药水冷却"
L["Shared Elixir Cooldown"] = "共享药剂冷却"
L["Global Cooldown"] = "公共冷却"
L["GCD"] = true -- abbreviation for Global Cooldown
L["Blood Rune"] = "鲜血符文"
L["Unholy Rune"] = "邪秽符文"
L["Frost Rune"] = "冰霜符文"
L["Death Rune"] = "死亡符文"
L["Failed to load "] = "加载失败"
L["Not Tracking"] = "没有监视"
L["Potions"] = "药水"
L["Elixirs"] = "药剂"
L["Fire Totem"] = "火图腾"
L["Water Totem"] = "水图腾"
L["Earth Totem"] = "大地图腾"
L["Air Totem"] = "空气图腾"

-- Profile.lua
L["Frost School"] = "冰霜抗性"
L["Fire School"] ="火焰抗性"
L["Nature School"] = "自然抗性"
L["Shadow School"] = "暗影抗性"
L["Arcane School"] = "奥术抗性"
L["Holy School"] = "神圣抗性"
L["Physical School"] = "物理抗性"
L["Locked out of Frost school of magic."] = "锁定冰霜抗性"
L["Locked out of Fire school of magic."] = "锁定火焰抗性"
L["Locked out of Nature school of magic."] ="锁定自然抗性"
L["Locked out of Shadow school of magic."] = "锁定暗影抗性"
L["Locked out of Arcane school of magic."] ="锁定奥术抗性"
L["Locked out of Holy school of magic."] = "锁定神圣抗性"
L["Locked out of Physical school of magic."] = "锁定物理抗性"

-- Bars.lua
L["Test Bar"] = "测试计时条组"
L["Custom Bar Group"] = true
L["Auto Bar Group"] = true
L["Anchor attached"] = '|cffffff00附着|r 到 "'
L["Anchor left click 1"] = "点击|cffffff00左键|r 解除附着以移动锚点"
L["Anchor left click 2"] = "点击|cffffff00左键|r 以移动锚点"
L["Anchor right click"] = "点击|cffffff00右键|r 以锁定并隐藏锚点"
L["Anchor shift left click"] = "|cffffff00Shift+左键|r 以显示/隐藏测试条"
L["Anchor shift right click"] = "|cffffff00Shift+右键|r 以显示/隐藏方向"
L["Anchor alt left click"] = "|cffffff00Alt+左键|r 以打开/关闭配置菜单"
L["Anchor alt right click"] = "|cffffff00Alt+右键|r 以配置循环"
L["Add filter"] = function(a, b, n) return string.format("Raven: \"%s\"已添加到 %s 过滤列表，计时条组： \"%s\"", a, b, n) end
L["Header click"] = "点击|cffffff00右键|r 以隐藏该单位直到重新选择目标或下一个buff/debuff由玩家应用"
L["<Applied by "] = "<应用 "

-- Conditions.lua
-- These strings are used in GetConditionText function to produce a detail condition description.
-- Many are also used in the options panel in the Conditions tab for defining tests.
L["Player Status"] = "玩家状态"
L["Target Status"] = "目标状态"
L["Focus Status"] = "焦点状态"
L["All Buffs"] = "所有BUFF"
L["Any Buffs"] = "任意BUFF"
L["Buff Time Left"] = "BUFF剩余时间"
L["Buff Count"] = "BUFF层数"
L["Buff Type"] = "BUFF类型"
L["All Debuffs"] = "所有Debuff"
L["Any Debuffs"] = "任意Debuff"
L["Debuff Time Left"] = "DEBUFF剩余时间"
L["Debuff Count"] = "DEBUFF层数"
L["Debuff Type"] = "DEBUFF类型"
L["All Cooldowns"] = "所有冷却"
L["Spell Ready"] = "法术就绪"
L["Spell Casting"] = "法术释放中"
L["Item Ready"] = "物品就绪"
L["Condition Name"] = function(name) return string.format("|cFF7adbf2条件名称:|r %s", name) end
L["(not found)"] = "(未找到)"
L["Disable String"] = " |cFFef2929[禁用]|r"
L["In Combat"] = "战斗中"
L["Out Of Combat"] ="战斗外"
L["Is Resting"] = "休息中"
L["Not Resting"] = "休息外"
L["Is Stealthed"] = "潜行"
L["Not Stealthed"] = "潜行外"
L["Is Fishing"] = "游泳中"
L["Not Fishing"] = "游泳外"
L["Is Mounted"] = "载具上"
L["Not Mounted"] = "载具外"
L["Is PvP"] = "PVP开启"
L["Not PvP"] = "PVP关闭"
L["In Group"] = "在团队中"
L["Not In Group"] = "不在团队中"
L["In Party"] = "在队伍中"
L["Not In Party"] = "不在队伍中"
L["In Raid"] = "在Raid中"
L["Not In Raid"] = "不在Raid中"
L["In Instance"] = "在副本中"
L["Not In Instance"] = "不在副本中"
L["In Arena"] = "在竞技场中"
L["Not In Arena"] = "不在竞技场中"
L["In Battleground"] = "在战场中"
L["Not In Battleground"] = "不在战场中"
L["Primary Talents"] = "主天赋"
L["If checked, bar group is shown when the player is in primary talents."] = "当玩家使用主天赋树时启用该计时条组"
L["Secondary Talents"] = "副天赋"
L["If checked, bar group is shown when the player is in secondary talents."] = "当玩家使用副天赋树时启用该计时条组"
L["Has Pet"] = "有宠物"
L["No Pet"] = "无宠物"
L["Level String"] = function(x, level) return string.format("等级 %s %d", x, level) end
L["Health String"] = function(x, minHealth) return string.format("生命值 %s %d%%", x, minHealth) end
L["Power String"] = function(x, minPower) return string.format("能量值 %s %d", x, minPower) end
L["Holy Power String"] = function(x, minPower) return string.format("圣能 %s %d", x, minPower) end
L["Shards String"] = function(x, minShards) return string.format("灵魂碎片 %s %d", x, minShards) end
L["Eclipse String"] = function(x, power) return string.format("月蚀能量 %s %d", x, power) end
L["Solar Eclipse"] = true
L["Lunar Eclipse"] = true
L["Combo Pts String"] = function(x, minComboPoints) return string.format("连击点: %s %d", x, minComboPoints) end
L["Stance String"] = function(stance) return string.format("姿态 = \"%s\"", stance) end
L["Talent String"] = function(talent) return string.format("天赋 = \"%s\"", talent) end
L["Blood"] = "鲜血"
L["Frost"] = "冰霜"
L["Unholy"] = "邪秽"
L["Rune"] = "符文"
L["Runes"] = "符文"
L["Mainhand String"] = function(level) return string.format("主手武器 >= %d", level) end
L["Offhand String"] = function(level) return string.format("副手武器 >= %d", level) end
L["Ranged String"] = function(level) return string.format("远程武器 >= %d", level) end
L["Exists"] = "存在"
L["Not Exists"] = "不存在"
L["Is Player"] = "是玩家"
L["Not Player"] = "不是玩家"
L["Is Enemy"] = "敌对"
L["Not Enemy"] = "非敌对"
L["Is Friendly"] = "友善的"
L["Not Friendly"] = "非友善的"
L["Is Dead"] = "死亡"
L["Not Dead"] = "未死亡"
L["In Range"] = "范围内"
L["Out Of Range"] = "范围外"
L["Is "] = "是"
L["Not "] = "不是"
L["On"] = "在"
L["Not All Active"] = "不全激活"
L["All Active"] = "全部激活"
L["None Active"] = "不激活"
L["Any Active"] = "任意激活"
L["Cast By Player"] = "由玩家释放"
L["Cast By Other"] = "由其他人释放"
L["Cast By Anyone"] = "由任何人释放"
L["Missing"] = "丢失"
L["Present"] = "目前"
L["Less Than"] = "小于"
L["Or More"] = "或更多"
L["Seconds"] = "秒"
L["Seconds Or More"] = "秒或更长"
L["Test Global Cooldown"] = "测试GCD"
L["Ignore Global Cooldown"] = "忽略GCD"
L["Ignore Spell Usable"] = "忽略法术可用"
L["Test Spell Usable"] = "测试法术可用"
L["Target In Range"] = "目标在范围内"
L["Target Out Of Range"] = "目标在范围外"
L["Cast By"] = "释放者:"
L["Item Is Not Ready"] = "物品未就绪"
L["Item Is Ready"] = "物品就绪"
L["Dependencies String"] = " \n|cFF7adbf2依赖于:|r"
L["True Color String"] = "|cFF8ae234真|r"
L["False Color String"] = "|cFFef2929假|r"
L["Logic AND String"] = "\n|cFF7adbf2以与逻辑进行评估测试, "
L["Logic OR String"] = "\n|cFF7adbf2以或逻辑进行评估测试, "
L["Toggle String"] = "显示结果|r"
L["No Toggle String"] = "不显示结构|r"
L["Set Result True"] = "\n|cFF7adbf2结果设为真|r"
L["Set Result False"] = "\n|cFF7adbf2结果设定为假|r"
L["Normal"] = "普通"
L["Boss"] = true
L["Elite"] = "精英"
L["Rare"] = "稀有"
L["Rare Elite"] = "稀有精英"

-- Nest.lua
L["Right-to-left bars, label left, icon left"] ="从右到左,文字在左边,图标在左边"
L["Left-to-right bars, label left, icon left"] ="从左到右,文字在左边,图标在左边"
L["Right-to-left bars, label right, icon left"] = "从右到左,文字在右边,图标在左边"
L["Left-to-right bars, label right, icon left"] = "从左到右,文字在右边,图标在左边"
L["Right-to-left bars, label left, icon right"] = "从右到左,文字在左边,图标在右边"
L["Left-to-right bars, label left, icon right"] = "从左到右,文字在左边,图标在右边"
L["Right-to-left bars, label right, icon right"] = "从右到左,文字在右边,图标在右边"
L["Left-to-right bars, label right, icon right"] = "从左到右,文字在左边,图标在右边"
L["Icons in rows, with right-to-left mini-bars"] = true
L["Icons in rows, with left-to-right mini-bars"] = true
L["Icons in columns, right-to-left mini-bars"] = true
L["Icons in columns, left-to-right mini-bars"] = true
L["Icons on horizontal timeline, no mini-bars"] = true
L["Icons on vertical timeline, no mini-bars"] = true

-- L["Buff button right click"] = "|cffffff00Right-click|r to cancel this buff"

-- Shared cooldowns
L["Portals"] = "头像"
L["Summon Infernal/Doomguard"] = "召唤地狱火/末日守卫"
L["Shouts"] = true
L["Pummel/Shield Bash"] = "拳击/盾击"
L["Crusader/Hammer"] = "十字军/锤"
L["Fire Traps"] = "爆炸陷阱"
L["Frost Traps"] = "冰霜陷阱"
L["Earth/Fire Elementals"] = "大地/火焰元素"
L["Shocks"] = "冲击"

-- All strings from here down are used for the options panel and are referenced in Options.lua.

L["Not valid string"] = function(n) return string.format("Raven: 警告 \"%s\" 不是一个有效的法术名称", n) end
L["Circular string"] = function(a, b) return string.format("Raven: \"%s\" 不能附着在 \"%s\" 因为会创建一个循环依赖", a, b) end
L["Dup bar group string"] = function(n) return string.format("重复的名称！ \n已经有一个命名为 %s 的计时条组. 希望覆盖它吗?", n) end
L["Dup condition string"] = function(n) return string.format("重复的名称 \n已经有一个命名为 %s的条件 .希望覆盖它吗?", n) end
L["is a duplicate of an existing bar label"] = "现有标签栏重复"
L["does not begin with a letter or contains restricted characters"] = "不能以字母开头,或包含了非法字符"
L["Type and condition string"] = function(t, a) return string.format("|cFF7adbf2类型:|r %s\n|cFF7adbf2条件:|r %s", t, a) end
L["Associated spell string"] = function(s) return string.format("\n|cFF7adbf2关联的法术:|r %s", s) end
L["Action type source string"] = function(a, t, s) return string.format("|cFF7adbf2动作:|r %s\n|cFF7adbf2类型:|r %s\n|cFF7adbf2来源:|r %s", a, t, s) end
L["Type source string"] = function(t, s) return string.format("|cFF7adbf2类型:|r %s\n|cFF7adbf2来源:|r %s", t, s) end
L["Action on cast by string"] = function(m, c) return string.format("\n|cFF7adbf2动作:|r %s\n|cFF7adbf2释放者:|r %s", m, c) end

-- Blizzard Addons option table
L["Configure"] = "配置"
L["Open Raven's standalone options panel."] = "开启Raven的独立配置面板"

-- Setup tab
L["Setup"] = "安装"
L["Enable Raven"] ="启用Raven"
L["If checked, Raven is enabled, otherwise all features are disabled."] = "启用Raven，除非所有模块被禁用"
L["Hide Blizzard Buffs"] = "隐藏系统自带BUFF"
L["If checked, Raven will hide the default user interface for buffs."] = "隐藏系统自带的BUFF界面"
L["Hide Blizzard Runes"] = "隐藏系统自带的符文条"
L["If checked, Raven will hide the default user interface for runes."] = "隐藏系统自带服务条"
L["Mute Raven Sound"] = "Raven禁音"
L["If checked, Raven will not play sound effects."] = "Raven将不播放音效"
L["Minimap Icon"] = "小地图图标"
L["If checked, Raven will add an icon to the minimap."] ="显示小地图图标"
L["Standard Bar Groups"] = "默认的计时条组"
L["Anchor description"] = "Raven 可以让你显示buff\debuff\冷却的图标和监视条 " ..
	'你可以在 "计时条组" 标签下进行设置,以配置一个个性化的界面. ' ..
	"想要开始的话,很简单,用列出默认的计时条组开始下手吧. " ..
	'选择你喜欢的计时条组,然后按"以条创建"或"以图标创建". ' ..
	'你可以像这样配置多次以创造出一个图标和条的组合.\n'
L["All buffs on you, sort by time left."] = "你身上的所有BUFF,以剩余时间排列"
L["Short Buffs"] = "排列BUFF"
L["Buffs on you lasting less than 2 minutes."] = "你身上的小于2分钟的BUFF"
L["Long Buffs"] = "长时间BUFF"
L["Buffs on you lasting at least 2 minutes, sort and color by class."] ="你身上的长于两分钟的BUFF将按照职业着色"
L["Debuffs"] = true
L["Debuffs on you."] ="你身上的DEBUFF"
L["Cooldowns"] = "冷却"
L["Cooldowns on your spells and trinkets lasting at least 2 seconds."] = "法术或饰品的大于2秒的冷却时间"
L["Target"] = "目标"
L["Buffs and debuffs you cast on the target."] = "目标身上由你释放的buff和debuff"
L["Focus"] = "焦点"
L["Buffs and debuffs you cast on the focus."] = "焦点身上由你释放的buff和debuff"
L["Totems"] = "图腾"
L["Totem tracker bars for Shaman players."] = "萨满的图腾监视"
L["Rune cooldown bars for Death Knight players."] = "DK的符文监视"
L["Notifications"] = "提示"
L["Common class-specific notifications."] = "默认的提示"
L["Buff Tracker"] = "Buff监视"
L["Buff tracker string"] = "你给目标释放的Buff (例如, HoT 计时)."
L["Debuff Tracker"] = "Debuff监视"
L["Debuff tracker string"] = "你给目标释放的Debuff (例如, DoT 计时)."
L["Timeline string"] = "法术和饰品冷却的时间线设定."
L["Create As Bars"] ="以条创建"
L["Create bars string"] = "将选定的计时条组以监视条创建 "
L["Create As Icons"] = "以图标创建"
L["Create icons string"] = "将选定的计时条组以监视图标创建."
L["Configure string"] = "创建计时条组\n你确定创建一个计时条组,并覆盖相同名字的计时条组?"
L["Reset selections."] = "重置"
L["Link"] = "链接"
L["Link settings string"] = "将选定的计时条组与配置文件中其他具有相同名称的计时条组链接在一起。被链接的计时条组具有相同的位置、布局和外观选项。"
L["Delete the selected bar groups."] = "删除选定的计时条组"
L["Delete standard string"] = "删除计时条组\n确定删除选定的计时条组?"
L["Bar Group Anchors"] = "计时条组锚点"
L["Bar group anchor string"] = "计时条组锚点决定将在哪里显示监视条 " ..
	"锚点的提示将列出有帮助的快捷方式(例如:在锚点上改变监视条的增长方向\测试等). " ..
	"你可以点击左键以拖动锚点。 " ..
	"当你对位置满意时你可以点击右键锁定. " ..
	'锁定的锚点将被隐藏--点击 "解锁全部锚点"按钮以显示他们.\n'
L["Lock All Anchors"] = "锁定全部锚点"
L["Lock and hide the anchors for all bar groups."] = "锁定并隐藏全部计时条组的锚点"
L["Unlock All Anchors"] = "解锁全部锚点"
L["Unlock and show the anchors for all bar groups."] = "解锁并显示全部计时条组的锚点"

-- Defaults tab
L["Defaults"] = "默认"
L["Defaults string"] = "在计时条组里的监视条拥有例如尺寸\字体和纹理的外观选项 " ..
	"您可以在这个选项界面中调整这些选项的默认值. " ..
	"这些设置将被所有的配置文件所共同采用，以便您使用多个角色.\n"
L["Bar Configurations"] = "条 配置"
L["Icon Configurations"] = "图标 配置"
L["Bar Width"] = "条宽度"
L["Set width of bars."] = "设定条的宽度"
L["Bar Height"] = "条高度"
L["Set height of bars."] = "设定条的高度"
L["Icon Size"] = "图标尺寸"
L["Set width/height for icons."] = "设定图标的宽度/高度"
L["Scale"] = "缩放"
L["Set scale factor for bars and icons."] = "设定条和图标的缩放"
L["Horizontal Spacing"] = "水平间距"
L["Adjust horizontal spacing between bars."] = "设定条之间的水平间距"
L["Vertical Spacing"] = "垂直间距"
L["Adjust vertical spacing between bars."] = "设定条之间的垂直间距"
L["Icon Inset"] = "图标水平偏移"
L["Set icon's horizontal inset from bar."] = "设定图标在条上的水平偏移"
L["Icon Offset"] = "图标垂直偏移"
L["Set vertical offset between icon and bar."] = "设定图标在条上的垂直偏移"
L["Reset Format"] = "重设格式"
L["Reset format to default settings."] = "将格式重设为默认"
L["RESET FORMAT\nAre you sure you want to reset the format options?"] ="重设格式\n你确定将格式重设为默认??"
L["Fonts and Textures"] = "字体和材质"
L["Label Text"] = "标签文本"
L["Font"] = "字体"
L["Select font."] = "选择字体"
L["Font Size"] = "字号"
L["Set font size."] = "设定字号"
L["Opacity"] = "不透明度"
L["Set text opacity."] = "设置文字不透明度"
L["Color"] = "颜色"
L["Outline"] = "描边"
L["Add black outline."] ="添加黑色描边"
L["粗边"] = ""
L["Add thick black outline."] ="添加黑色粗边"
L["Mono"] = true
L["Render font without antialiasing."] = "不采用反锯齿渲染字体"
L["Shadow"] ="阴影"
L["Show shadow with text."] ="显示文字阴影"
L["Time Text"] = "时间文字"
L["Icon Text"] = "图标文字"
L["Bars and Icons"] = "条和图标"
L["Bar Foreground Texture"] = "条的前景材质"
L["Select foreground texture for bars."] ="选择条的前景材质"
L["Foreground Opacity"] = "前景透明度"
L["Set foreground opacity for bars."] = "设置前景的透明度"
L["Bar Background Texture"] = "条的背景材质"
L["Select background texture for bars."] = "选择条的背景材质"
L["Background Opacity"] = "背景透明度"
L["Set background opacity for bars."] = "设置条的背景透明度"
L["Panels and Borders"] = "面板和边框"
L["Background Panel"] ="背景面板"
L["Enable display of a background panel behind bar group."] = "在计时条组的背后显示背景面板"
L["Panel Texture"] = "面板材质"
L["Select texture to display in panel behind bar group."] = "选择背景面板的材质"
L["Adjust padding between bar group and the background panel and border."] = "设置计时条组和背景面板、边框之间的间距"
L["Set fill color for the panel."] = "选择面板的填充颜色"
L["Background Border"] ="背景边框"
L["Select border to display behind bar group (select None to disable border)."] = "选择计时条组背景的边框材质"
L["Adjust inset from the border to background panel's fill color."] = "设定边框和背景面板的间距"
L["Set color for the border."] = "设置边框颜色"
L["Bar Border"] = "条边框"
L["Select border for bars in the bar group (select None to disable border)."] ="设定计时条组中的监视条的边框"
L["Adjust size of the border's edge."] = "设定边沿的尺寸"
L["Adjust offset to the border from the bar."] = "设定边框和条的间距"
L["Set border's offset from the bar."] = "设定边框与条的间距"
L["Edge Size"] = "边沿尺寸"
L["Inset"] = "偏移"
L["Offset"] ="偏移"
L["Padding"] = "填充"
L["Border Color"] = "边框颜色"
L["Panel Color"] = "面板颜色"
L["Foreground Saturation"] = "前景饱和度"
L["Set saturation for foreground colors."] = "设定前景的饱和度"
L["Foreground Brightness"] = "前景亮度"
L["Set brightness for foreground colors."] = "设定前景的亮度"
L["Background Saturation"] = "背景饱和度"
L["Set saturation for background colors."] = "设置背景的饱和度"
L["Background Brightness"] = "背景亮度"
L["Set brightness for background colors."] = "设置背景的保护度"
L["Opacity (Not Combat)"] = "战斗外透明度"
L["Set opacity for bars/icons when not in combat."] = "设定战斗外的透明度"
L["Opacity (In Combat)"] = "战斗中透明度"
L["Set opacity for bars/icons when in combat."] = "设定战斗中的透明度"
L["Icon Border Saturation"] = "图标边框饱和度"
L["Set saturation for icon border colors."] = "设置图标边框的饱和度"
L["Icon Border Brightness"] = "图标边框亮度"
L["Set brightness for icon border colors."] = "设置图标边框亮度"
L["Reset Fonts/Textures"] = "重设字体/材质"
L["Reset fonts and textures to default settings."] = "重设材质/字体到默认"
L["RESET FONTS/TEXTURES\nAre you sure you want to reset the font and texture options?"] ="重设字体/材质\n确定将字体和材质重设到默认?"
L["Standard Colors"] = "标准颜色"
L["Bar Colors:"] ="条颜色:"
L["Notify"] = "提示"
L["Buff"] = true
L["Debuff"] = true
L["Cooldown"] ="冷却"
L["Buffs"] = true
L["Debuff Colors:"] = "Debuff颜色"
L["Curse"] = "诅咒"
L["Magic"] = "魔法"
L["Disease"] = "疾病"
L["Poison"] = "中毒"
L["Reset Bar Colors"] = "重设条颜色"
L["Reset bar colors back to default."] = "将条颜色重设为默认"
L["RESET BAR COLORS\nAre you sure you want to reset bar colors back to default?"] = "重设条颜色\n确定要把条颜色重设为默认值?"
L["Reset Debuff Colors"] = "重设Debuff颜色"
L["Reset debuff colors back to default."] = "将Debuff颜色重设为默认"
L["RESET DEBUFF COLORS\nAre you sure you want to reset debuff colors back to default?"] = "重设Debuff颜色\n确定要把Debuff颜色重设为默认值?"
L["OmniCC"] = true
L["Hide OmniCC"] = "隐藏OmniCC"
L["If checked, OmniCC counts are hidden on icons in all bar groups (requires /reloadui)."] = "在图标上隐藏OmniCC计时"
L["Masque/Button Facade"] = ""
L["If checked, icons are skinned with Masque (formerly known as Button Facade)."] = "勾选，则图标使用Masque皮肤"
L["Color Normal Texture"] = "默认材质颜色"
L["If checked, icon border color is applied to the normal texture."] = "勾选,则边框将使用默认材质"
L["Color Border Texture"] = "边框材质颜色"
L["If checked, icon border color is applied to the border texture."] = "勾选,则边框将使用边框材质"
L["Sound Channel"] = "音效通道"
L["Master"] ="主声音"
L["If checked, sound is played in Master channel."] = "勾选,则声音通过游戏主声音播放"
L["SFX"] = true
L["If checked, sound is played in SFX channel."] = "勾选,则声音通过SFX通道播放"
L["Music"] = "音乐"
L["If checked, sound is played in Music channel."] = "勾选,则声音通过音乐频道播放"
L["Ambience"] = "环境"
L["If checked, sound is played in Ambience channel."] = "勾选,则声音通过环境通道播放"

-- Spells tab
L["Spells"] ="法术"
L["Spells string"] = "法术标签可定义与法术有关联的颜色和标签. " ..
	"这些设置将被所有的配置文件所共同采用，以便您使用多个角色. " ..
	"您也可以创建法术列表,并在本标签指定他们的GCD和效果计时器.\n"
L["Colors and Labels"] = "颜色和标签"
L["Spell Name"] = "法术名字"
L["Enter spell name (or numeric identifier) whose color you want to change."] = "输入你要修改颜色的法术名称"
L["Select a standard color or click to set a custom color."] = "选择一个颜色"
L["Spell Label"] = "法术标签"
L["Enter a label to be used by default with this spell."] = "输入一个这个法术默认使用的标签文字"
L["Spell Sound"] = "法术声音"
L["Select sound to associate with the spell."] = "选择一个与这个法术关联的声音"
L["Reset"] = "重设"
L["Reset color and label string"] = function(s) return string.format("重设 %s  的颜色,标签和声音", s) end
L["Reset color and label confirm"] = function(s) return string.format("重设法术\n你确定重设 %s 的颜色,标签和声音?", s) end
L["Reset Spell Colors"] = "重设法术颜色"
L["Reset spell colors back to defaults."] = "重设法术颜色到默认"
L["RESET SPELL COLORS\nAre you sure you want to reset all spell colors back to defaults?"] ="重设法术颜色\n确定将法术颜色重设到默认?"
L["Reset Spell Labels"] ="重设标签"
L["Reset spell labels back to defaults."] ="重设标签到默认"
L["RESET SPELL LABELS\nAre you sure you want to reset all spell labels back to defaults?"] ="重设标签\n确定将标签重设到默认?"
L["Reset Spell Sounds"] = "重设声音"
L["Reset spell sounds back to defaults."] = "重设声音到默认"
L["RESET SPELL SOUNDS\nAre you sure you want to reset all spell sounds back to defaults?"] ="重设法术声音\n确定将法术声音重设到默认?"
L["Internal Cooldowns Triggered By Buffs/Debuffs"] = "由buff/debuff引起的内部冷却"
L["Internal Cooldowns"] = "内部冷却"
L["Enable detecting internal cooldowns."] = "启用内部冷却"
L["Cooldown List"] = "冷却列表"
L["New Cooldown"] = "新冷却"
L["Enter a new internal cooldown triggered by a buff or debuff."] = "输入一个引发内部冷却的Buff/Debuff"
L["Enter Spell Name or ID"] = "输入名称或法术ID"
L["Enter buff or debuff spell name or numeric identifier for new internal cooldown."] = "输入一个引发内部冷却的Buff/Debuff的名称或法术ID"
L["Cancel creating a new internal cooldown."] = "取消创建内部冷却"
L["Delete Cooldown"] = "删除"
L["Delete the selected internal cooldown."] = "删除选择的内部冷却计时"
L["Delete cooldown string"] = "删除冷却\n你确定要删除冷却即使?"
L["Enter duration in seconds."] = "输入持续时间(单位:秒)"
L["Enable detecting this internal cooldown."] = "输入内部冷却的时间"
L["If checked, test if buffs/debuffs were cast by the player."] = "测试:若这个buff/debuff由玩家释放"
L["Cast On Player"] = "由玩家释放"
L["If checked, test if buffs/debuffs are on the player and cast by anyone other than the player."] = true
L["Reset List"] = "重设列表"
L["Enter comma-separated list of buffs or debuffs (either spell names or numeric identifiers) that reset the internal cooldown."] = "输入以逗号分隔的buff/debuff名称或ID以重设内部CD列表"
L["Reset Cooldowns"] ="重设冷却"
L["Reset all internal cooldowns back to defaults."] ="重设所有的内部CD"
L["RESET COOLDOWNS\nAre you sure you want to reset all internal cooldowns back to defaults?"] = "重设内部CD\n确定要重设全部的内部CD?"
L["Effect Timers Triggered By Spell Casts"] = "通过法术触发效果计时器"
L["Enable detecting spell effects."] = "启用检测法术效果"
L["Spell Effect List"] = "法术效果列表"
L["New Spell Effect"] ="新法术效果"
L["Enter a new spell effect triggered by a successful spell cast."] = "输入一个新的法术释放成功所产生的法术效果"
L["Enter spell name or numeric identifier that, when cast, will trigger a new spell effect."] = "输入当法术释放成功时产生的法术效果的名称或ID"
L["Cancel creating a new spell effect."] = "取消创建法术效果"
L["If checked, spell effect is a buff."] = "该效果是BUFF"
L["If checked, spell effect is a debuff."] = "该效果是DEBUFF"
L["If checked, spell effect is a cooldown."] = "该效果是冷却时间"
L["Delete Spell Effect"] = "删除法术效果"
L["Delete the selected spell effect."] = "删除法术效果"
L["Delete effect string"] = "删除法术效果\n确定删除法术效果?"
L["Enable detecting this spell effect."] = "启用检测此法术效果"
L["Renew"] = "更新"
L["If checked, spell effect is renewed if spell is cast again while effect is active."] = "当该效果再一次释放时该法术效果将被更新"
L["If checked, include name of caster in the label if spell effect is a buff or debuff."] = "若该效果是buff或debuff时,在标签里包含释放者的名称"
L["Enter spell name or numeric identifier for spell to be associated with this effect (default is to use spell that triggers the effect)."] = "输入法术效果的名称或法术ID"
L["Required Talent"] = "需要天赋"
L["Enter name or numeric identifier for talent required for effect to happen (leave blank if no talent required)."] = "输入触发该效果需要的天赋名称或id"
L["Required Buff"] = "需要Buff"
L["Enter name or numeric identifier for buff required to be active on player for effect to happen (leave blank if no buff required)."] =  "输入触发该效果需要的buff名称或id"
L["Required Condition"] = "需要条件"
L["Enter name of condition required to be true for effect to happen (leave blank if no condition required)."] = "输入触发该效果所需的前提条件"
L["If checked, spell must be cast by the player to trigger the spell effect."] = "该效果必须由玩家释放的法术触发"
L["If checked, spell must be cast by the player's pet to trigger the spell effect."] = "该效果必须由玩家的宠物释放的法术触发"
L["If checked, spell must be cast by the target to trigger the spell effect."] = "该效果必须由目标释放的法术触发"
L["If checked, spell must be cast by the focus to trigger the spell effect."] = "该效果必须由焦点释放的法术触发"
L["If checked, spell must be cast by anyone other than the player or pet to trigger the spell effect."] = "该效果必须由除玩家或宠物之外的其他目标触发"
L["If checked, trigger the spell effect if the spell is cast by anyone, including player."] = "该效果可以由任何人触发"
L["Spell Lists"] = "法术列表"
L["Spell List"] = "法术列表"
L["New Spell List"] = "新法术列表"
L["Create a new spell list."] = "创建新的法术列表"
L["Enter Spell List Name"] = "输入新的法术列表名称"
L["Enter name for a new spell list."] = "输入新的法术列表名称"
L["Cancel creating a new spell list."] = "取消创建新的法术列表"
L["Delete Spell List"] = "删除法术列表"
L["Delete the selected spell list."] = "删除选定的法术列表"
L["Delete spell list string"] = "删除法术列表\n你确定要删除法术列表?"
L["Enter Spell"] = "输入法术"
L["Enter a spell name (or numeric identifier, optionally preceded by # for a specific spell id) to be added to the list."] = "输入法术名称或ID以添加到法术列表"
L["Delete the selected spell from the list."] = "从列表中删除选定的法术"
L["Reset the spell list."] = "重置法术列表"
L['RESET\nAre you sure you want to reset the spell list?'] = '重置\n确定要重置法术列表?'

-- Bar Groups tab
L["Bar Groups"] = "计时条组"
L["Bar Group"] = "计时条组"
L["New Custom Group"] = "新建自定义计时条组"
L["Create a new bar group with manually added bars."] = "以手动添加的方式创建一个新的条组"
L["New Auto Group"] = "新建自动计时条组"
L["Create a new bar group with automatically displayed bars."] = "以自动添加的方式创建一个新的条组"
L["Enter Custom Group Name"] = "输入自定义计时条组名称"
L["Enter name of new custom bar group."] = "输入新建的计时条组名称"
L["Invalid name."] = "有效名称"
L["Enter Auto Group Name"] = "输入自动计时条组名称"
L["Enter name of new auto bar group."] = "输入自动计时条组的名称"
L["Cancel"] = "取消"
L["Cancel creating a new bar group."] = "取消创建计时条组"
L["Delete Bar Group"] = "删除计时条组"
L["Delete the selected bar group."] = "删除选中的计时条组"
L["Delete bar group string"] = function(s) return string.format("删除计时条组\n你确定要删除计时条组 %s ?", s) end

-- Bar Groups > General tab
L["General"] = "一般"
L["Settings"] = "设定"
L["Enable Bar Group"] = "启用计时条组"
L["Enable bar group string"] = "若选中,计时条组将被启用,锚点和监视条将会显示, " ..
	"除非该计时条组或锚点为不可见的."
L["Merge Bar Group"] = "合并计时条组"
L["Merge bar group string"] = "若选中，将合并其他计时条组中的监视条. " ..
	"监视条将继承该计时条组的设定, " ..
	"但排列和布局仍使用其他条的设定."
L["Link Settings"] = "链接设定"
L["Link settings string"] = "若选中,该计时条组的配置" ..
	"将和其他配置文件中同名的计时条组同步."
L["Save Settings"] = "保存设定"
L["Click to save current settings to linked settings."] = "点击以保存当前设定与链接设定"
L["Bar Group To Merge Into"] = "要合并的计时条组"
L["Select a bar group to merge into."] = "选择一个要合并的计时条组"
L["Rename Bar Group"] = "重命名计时条组"
L["New Name"] = "新名字"
L["Enter new name for the bar group."] = "为计时条组输入一个新名字"
L["Sort Order"] = "排序"
L["A to Z"] = "A到Z"
L["If checked, sort in ascending alphabetical order starting at bar closest to the anchor."] = true
L["Time Left"] ="时间剩余"
L["If checked, sort by time left in ascending order starting at bar closest to the anchor."] = true
L["Duration"] = "时间"
L["If checked, sort by overall duration in ascending order starting at bar closest to the anchor."] = true
L["Creation"] = "创建"
L["If checked, show bars in order created with oldest bar closest to the anchor."] = true
L["Class"] = "职业"
L["If checked, sort by associated class name, if any, in ascending alphabetical order starting at bar closest to the anchor."] = true
L["Custom"] = "默认"
L["If checked, allow manually setting the order of bars."] = true
L["Reverse Order"] = "反转排序"
L['If checked, reverse the sort order (e.g., "A to Z" becomes "Z to A").'] = "反转排序(比如A-Z变成Z-A)"
L["Show When"] = "显示,当:"
L["If checked, bar group is shown when the player is in combat."] ="当在战斗中时显示"
L["If checked, bar group is shown when the player is out of combat."] = "当在战斗外显示"
L["Resting"] = "休息"
L["If checked, bar group is shown when the player is resting."] = true
L["Mounted"] ="坐骑上"
L["If checked, bar group is shown when the player is mounted."] = true
L["Vehicle"] = "载具上"
L["If checked, bar group is shown when the player is in a vehicle."] = true
L["Enemy"] = "敌人"
L["If checked, bar group is shown when the target is an enemy."] ="目标是敌人时显示"
L["Friendly"] = "友善"
L["If checked, bar group is shown when the target is friendly."] = "目标是友善时显示"
L["Focus=Target"] = true
L["If checked, bar group is shown when focus is same as target."] = "当目标与焦点相同时"
L["Solo"] = "独自"
L["If checked, bar group is shown when the player is not in a party or raid."] ="不在队伍或团队时显示"
L["If checked, bar group is shown when the player is in a party."] = "在队伍中时显示"
L["If checked, bar group is shown when the player is in a raid."] = "在团队中时显示"
L["If checked, bar group is shown when the player is in a 5-man or raid instance."] = "在5人副本或团队副本中时显示"
L["If checked, bar group is shown when the player is not in a 5-man or raid instance."] = "不在5人副本或团队副本时显示"
L["If checked, bar group is shown when the player is in an arena."] = "竞技场中显示"
L["If checked, bar group is shown when the player is in a battleground."] = "战场中显示"
L["Fishing"] = "钓鱼"
L["If checked, bar group is shown when the player is ready to fish (i.e., trained with fishing pole equipped)."] = "把鱼竿拿在手上时显示"
L["Blizzard Buffs Enabled"] ="启用系统自带BUFF"
L["If checked, the bar group is shown if the default user interface for buffs is enabled."] = true
L["Blizzard Buffs Disabled"] = "禁用系统自带BUFF"
L["If checked, the bar group is shown if the default user interface for buffs is disabled."] = true
L["Condition Is True"] = "条件为真"
L["If checked, bar group is shown only when the selected condition is true."] = true
L["Condition"] ="条件"
L["Player Class"] = "玩家职业"
L["Start Spell Sound"] = "法术开始音效"
L["Play associated spell sound, if any, when bar starts (spell sounds are set up on Spells tab)."] = "请选择法术音效,如果选择,则在条开始时同时播放该声音"
L["Alternative Start Sound"] = "改变开始音效"
L["Select sound to play when bar starts and there is no associated spell sound (or start spell sounds are not enabled)."] = "选择法术开始时需要播放的音效."
L["Replay"] = "重放"
L["Enable replay of start sound (after a specified amount of time) while bar is active."] = "启用反复播放开始音效"
L["Replay Time"] = "重复次数"
L["Replay Start Sound"] = "重放开始声音"
L["Set number of seconds between replays of start sound."] = "设置开始声音的重放时间,单位秒"
L["Finish Spell Sound"] = "法术结束音效"
L["Play associated spell sound, if any, when bar finishes (spell sounds are set up on Spells tab)."] = "播放关联的音效,当条走完的时候播放"
L["Alternative Finish Sound"] = "更改结束音效"
L["Select sound to play when bar finishes and there is no associated spell sound (or finish spell sounds are not enabled)."] = "选择法术结束时需要播放的音效."
L["Expire Spell Sound"] = "法术将结束音效"
L["Play associated spell sound, if any, when bar is about to expire (spell sounds are set up on Spells tab)."] =  "选择法术将要结束时需要播放的音效."
L["Alternative Expire Sound"] = "更改法术将结束音效"
L["Select sound to play when bar is about to expire and there is no associated spell sound (or expire spell sounds are not enabled)."] ="选择法术将要结束时需要播放的音效."
L["Expire Time"] = "到期时间"
L["Set number of seconds before expiration that bar should change color and/or play expire sound."] ="设置还剩多少时间的时候条将变色/播放将要结束音效"
L["Minimum Duration"] = "最短时间"
L["Set minimum duration in minutes required to trigger expiration options."] ="设置将结束选项所适用的法术最短时间,单位秒"
L["Color When Expiring"] = "到期颜色"
L["Enable color changes for expiring bars (and, for icon configurations, make background visible if opacity is set to invisible to enable bar as highlight)."] =  "选择法术将要结束时需要条的颜色."
L["Set bar color for when about to expire (set invisible opacity to disable color change)."] ="选择法术将要结束时需要条的颜色."
L["Set label color for when bar is about to expire (set invisible opacity to disable color change)."] = "选择法术将要结束时需要标签的颜色."
L["Set time color for when bar is about to expire (set invisible opacity to disable color change)."] = "选择法术将要结束时需要时间的颜色."
L["Combat Text"] = "战斗文字"
L["Enable warning in combat text for expiring bars."] = "在战斗文字中为将过期的法术提示"
L["Critical"] = "暴击"
L["Enable combat text warning as critical."] = "提示以暴击数字的形式提示"
L["Set color for combat text warning."] = "设置战斗文字的颜色"
L["expiring"] = "到期"
L["Miscellaneous Options"] = "其他选项"
L["Frame Strata"] = "框体层次"
L["Frame strata string"] = "选择框体层次,以便让计时条组处于其他UI元素之前或之后."
L["Lock"] ="锁定"
L["Lock and hide the anchor for the bar group."] = "锁定并隐藏计时条组的锚点"
L["Unlock"] = "解锁"
L["Unlock and show the anchor for the bar group."] ="解锁并显示计时条组的锚点"
L["Non-Interactive"] = "非交互的"
L["If checked, the bar group is non-interactive and doesn't show tooltips or respond to clicks."] = "勾选,则该计时条组不响应鼠标事件"
L["Only Icons Interact"] = "只有图标互动"
L["If checked, only icons show tooltips and respond to clicks, otherwise entire bar does."] = "勾选,则计时条组中只有图标响应鼠标事件"
L["Tooltip Anchor"] = "提示锚点"
L["Tooltip anchor string"] = "设置提示的锚点(\"DEFAULT\" 设置为默认)."
L["Combat Tooltips"] = "战斗中显示提示"
L["If checked, tooltips are shown during combat."] = "勾选,则提示会在战斗中显示"
L["Caster"] = "释放者"
L["If checked, tooltips include caster for buffs and debuffs when known."] = "勾选,则在释放者可知时显示释放者"
L["Show Headers"] = "显示标题"
L["When showing all buffs or debuffs cast by player, add headers for each affected target."] = "当显示玩家释放的所有BUFF/DEBUF,为每个受影响的目标添加标题"
L["Sort Target First"] = "首先排序目标"
L["When showing all buffs or debuffs cast by player, sort ones for target first."] = "当显示玩家释放的所有BUFF/DEBUFF,排序目标."
L["Non-Target Opacity"] = "无目标时的透明度"
L["When showing all buffs or debuffs cast by player, set opacity for ones not on target."] = "没选择目标时计时条组的透明度"
L["Targets"] = "目标"
L["When showing all buffs or debuffs cast by player without headers, show target names in labels."] ="当显示玩家释放的所有BUFF/DEBUF,在标签上显示目标名字"
L["When showing all buffs or debuffs cast by player without headers, show spell names in labels."] = "当显示玩家释放的所有BUFF/DEBUF,在标签上显示法术名字"

-- Bar Groups > Custom Bars tab
L["Custom Bars"] = "自定义条"
L["New"] = "新建"
L["Create a new bar."] = "以新的条创建"
L["Delete the selected bar."] = "删除选定的条"
L['DELETE BAR\nAre you sure you want to delete the selected bar?'] = "删除条\n确定删除选定的条?"

-- Bar Groups > Buffs tab
L["Auto Buffs"] = "自动BUFF"
L['Enable automatically displaying bars for buffs that match these settings.'] = "启用自动为符合这些设置的buff创建条"
L["All Cast By Player"] = "所有由玩家释放的法术"
L['Include all buffs cast by player on others.'] = "所有目标的由玩家释放的法术"
L["Action On"] = "动作于:"
L["If checked, only add bars for buffs if they are on the player."] = "勾选,则只为释放在玩家身上的buff创建条"
L["If checked, only add bars for buffs if they are on the player's pet."] = "勾选,则只为释放在宠物身上的buff创建条"
L["If checked, only add bars for buffs if they are on the target."] = "勾选,则只为释放在玩目标上的buff创建条"
L["If checked, only add bars for buffs if they are on the focus."] = "勾选,则只为释放在焦点身上的buff创建条"
L["Exclude On"] = "排除"
L["If checked, exclude buffs if they are on the player."] = "勾选,则排除释放在玩家身上的buff"
L["If checked, exclude buffs if they are on the player's pet."] =  "勾选,则排除释放在玩家宠物身上的buff"
L["If checked, exclude buffs if they are on the target."] =  "勾选,则排除释放在目标身上的buff"
L["If checked, exclude buffs if they are on the focus."] = "勾选,则排除释放在焦点身上的buff"
L["Mouseover"] = "鼠标滑过"
L["Pet's Target"] = "宠物目标"
L["Target's Target"] = "目标的目标"
L["Focus's Target"] = "焦点目标"
L["If checked, only add bars for buffs if they are on the mouseover unit."] = "勾选,则只为释放在鼠标滑过的目标身上的buff创建条"
L["If checked, only add bars for buffs if they are on the pet's target."] = "勾选,则只为释放在宠物的目标身上的buff创建条"
L["If checked, only add bars for buffs if they are on the target's target."] = "勾选,则只为释放在目标的目标身上的buff创建条"
L["If checked, only add bars for buffs if they are on the focus's target."] = "勾选,则只为释放在焦点的目标身上的buff创建条"
L["If checked, only add bars for buffs if cast by the player."] = "勾选,则只为玩家释放的buff创建条"
L["If checked, only add bars for buffs if cast by the player's pet."] =  "勾选,则只为玩家宠物释放的buff创建条"
L["If checked, only add bars for buffs if cast by the target."] =  "勾选,则只为目标释放的buff创建条"
L["If checked, only add bars for buffs if cast by the focus."] =  "勾选,则只为焦点释放的buff创建条"
L["If checked, only add bars for buffs if cast by anyone other than the player or pet."] =  "勾选,则只为除了玩家和玩家宠物外其他人释放的buff创建条"
L["If checked, add bars for buffs if cast by anyone, including player."] =  "勾选,则为任何人释放的buff创建条"
L["Other"] = "其他"
L["Anyone"] = "任何人"
L["Filter By Type"] = "以类型过滤"
L["Filter buff types string"] = "只为所选类型的buff创建条"
L["Tracking"] = "监视"
L["Include Tracking"] = "包括监视"
L["Show Only Tracking"] = "只显示监视的法术"
L['Include the active tracking types as buffs.'] = "把监视的法术看作buff"
L['Include only the active tracking types.'] = "包括其他的激活的监视类型"
L["Stealable"] = "可偷取"
L['Include buffs that mages can spellsteal.'] = "包括法师可偷取的法术类型"
L['Include magic buffs (these can usually be removed with abilities like Purge).'] = "包括魔法法术"
L['Include other buffs not selected with filter types.'] = "包括所选的其他类型"
L["Filter List"] = "过滤列表"
L["Black List"] = "黑名单"
L["White List"] = "白名单"
L["Use Spell List"] = "适用法术列表"
L["If checked, filter list includes spells in specified spell list (these are set up on the Spells tab)."] = true
L["If checked, don't display any buffs that are in the filter list."] = true
L["If checked, only display buffs that are in the filter list."] = true
L["If checked, the filter list is shared with bar groups in other profiles with the same name."] = "勾选,则该列表将与配置文件中其他同名列表共享"
L["Enter Buff"] = "启用Buff"
L["Enter a buff to be added to the filter list."] = "输入一个要添加到过滤列表的法术名称"
L["Delete the selected buff from the filter list."] = "从过滤列表中删除选定的buff"
L["Reset the buff filter list."] = "重设过滤列表"
L['RESET\nAre you sure you want to reset the buff filter list?'] = "重设\n确定重设buff的过滤列表?"
L["Filter Bar Group"] = "过滤计时条组"
L["Select filter bar group."] = "选择过滤的计时条组"
L["Filter buff bar group string"] = "勾选,则不在计时条组中显示buff,如果选定了自定义计时条组,则不在自定义计时条组中显示buff.如果自动选择计时条组,不显示在过滤列表里的buff."

-- Bar Groups > Debuffs tab
L["Auto Debuffs"] = "自动debuff"
L['Enable automatically displaying bars for debuffs that match these settings.'] = "启用自动为符合这些设置的buff创建条"
L['Include all debuffs cast by player on others.'] = "所有目标的由玩家释放的法术"
L["Only Show Dispellable"] = "只显示可驱散的"
L['If check, only show debuffs that can be dispelled by the player.'] = "若勾选,则只显示可被玩家驱散的debuff"
L["If checked, exclude debuffs if they are on the player."] = "若勾选,则排除施放于玩家的debuff"
L["If checked, exclude debuffs if they are on the player's pet."] = "若勾选,则排除施放于玩家宠物身上的debuff"
L["If checked, exclude debuffs if they are on the target."] ="若勾选,则排除施放于目标的debuff"
L["If checked, exclude debuffs if they are on the focus."] ="若勾选,则排除施放于焦点的debuff"
L["If checked, only add bars for debuffs if they are on the player."] = "若勾选,则只为施放于玩家的debuff添加计时条"
L["If checked, only add bars for debuffs if they are on the player's pet."] ="若勾选,则只为施放于玩家宠物的debuff添加计时条"
L["If checked, only add bars for debuffs if they are on the target."] = "若勾选,则只为施放于目标的debuff添加计时条"
L["If checked, only add bars for debuffs if they are on the focus."] = "若勾选,则只为施放于焦点的debuff添加计时条"
L["If checked, only add bars for debuffs if they are on the mouseover unit."] = "若勾选,则只为施放于鼠标滑过的玩家的debuff添加计时条"
L["If checked, only add bars for debuffs if they are on the pet's target."] = "若勾选,则只为施放于玩家的宠物目标debuff添加计时条"
L["If checked, only add bars for debuffs if they are on the target's target."] = "若勾选,则只为施放于目标的目标的debuff添加计时条"
L["If checked, only add bars for debuffs if they are on the focus's target."] = "若勾选,则只为施放于焦点目标的debuff添加计时条"
L["If checked, only add bars for debuffs if cast by the player."] = "若勾选,则只为由玩家释放的debuff添加计时条"
L["If checked, only add bars for debuffs if cast by the player's pet."] ="若勾选,则只为由玩家宠物释放的debuff添加计时条"
L["If checked, only add bars for debuffs if cast by the target."] ="若勾选,则只为由目标释放的debuff添加计时条"
L["If checked, only add bars for debuffs if cast by the focus."] ="若勾选,则只为由焦点释放的debuff添加计时条"
L["If checked, only add bars for debuffs if cast by anyone other than the player or pet."] = "若勾选,则只为由除玩家和宠物之外任何人释放的debuff添加计时条"
L["If checked, add bars for debuffs if cast by anyone, including player."] = "若勾选,则只为由任何人释放的debuff添加计时条"
L["If checked, don't display any debuffs that are in the filter list."] = "若勾选,则不显示在过滤列表中的法术"
L["If checked, only display debuffs that are in the filter list."] = "若勾选,则只显示在过滤列表中的法术"
L["Dispellable"] = "可驱散"
L["Filter debuff types string"] = "只显示选中类型的debuff."
L['Include other debuffs not selected with filter types.'] = "包括其他未选择的过滤类型"
L['Include debuffs that the player can dispel.'] = "包括玩家可驱散的法术"
L['Include debuffs cast by boss.'] = "包括由boss释放的debuff"
L['Include poison debuffs.'] = "包括中毒debuff"
L['Include curse debuffs.'] = "包括诅咒debuff"
L['Include magic debuffs.'] = "包括魔法debuff"
L['Include disease debuffs.'] = "包括疾病debuff"
L["If checked, the debuff filter list is shared with bar groups in other profiles with the same name."] = "勾选,则该列表将与配置文件中其他同名列表共享"
L["Enter Debuff"] = "输入debuff名称"
L["Enter a debuff to be added to the filter list."] = "输入要添加到过滤列表的法术名称"
L["Delete the selected debuff from the filter list."] = "从过滤列表中删除选中的debuff"
L["Reset the debuff filter list."] = "重设debuff过滤列表"
L['RESET\nAre you sure you want to reset the debuff filter list?'] = "重设\n确定重设debuff过滤列表?"
L["Filter debuff bar group string"] = "勾选,则不在计时条组中显示debuff,如果选定了自定义计时条组,则不在自定义计时条组中显示debuff.如果自动选择计时条组,不显示在过滤列表里的debuff."

-- Bar Groups > Cooldowns tab
L["Auto Cooldowns"] = "自动冷却"
L['Enable automatically displaying bars for cooldowns that match these settings.'] = "启用自动为符合这些设置的buff创建条"
L["Action By"] = "动作:"
L["If checked, only add bars for cooldowns associated with the player."] = "勾选,则只为玩家的冷却创建计时条"
L["If checked, only add bars for cooldowns associated with the player's pet."] = "勾选,则只为玩家宠物的冷却创建计时条"
L["If checked, add bars for cooldowns cast by either player or player's pet."] = "勾选,则同时为玩家和玩家宠物创建计时条"
L["Include"] = "包括"
L["If checked, include bars for spell cooldowns."] ="勾选,则为法术冷却包括计时条"
L["Trinkets"] = "饰品"
L["If checked, include bars for cooldowns on equipped trinkets."] = "勾选.则计时条组包含已装备物品的冷却"
L["If checked, include bars for internal cooldowns triggered by a buff or debuff."] = "勾选,则计时条组包括debuff和buff引起的GCD"
L["Effect Timers"] = "生效计时器"
L["If checked, include bars for effect timers triggered by a spell cast."] ="勾选,则计时条组包括法术触发的计时器"
L["Weapon Buffs"] = "武器buff"
L["If checked, include bars for weapon buffs."] = "勾选,则计时条组包括武器buff"
L["Potions/Elixirs"] = "药水/药剂"
L["If checked, include bars for shared potion/elixir cooldowns (an item subject to the shared cooldown must be in your bags in order for the cooldown to be detected)."] = "勾选,则计时条组包括药水或药剂的冷却"
L["If checked, include bars for other cooldowns (for item cooldowns, an item subject to the cooldown must be in your bags in order for the cooldown to be detected)."] = "勾选,则为其他冷却创建计时条"
L["Shared Cooldowns"] ="共享冷却"
L["If checked, only show one cooldown for hunter Frost Traps."] = "勾选,则为猎人的冰霜陷阱只创建一个冷却计时"
L["If checked, only show one cooldown for hunter Fire Traps."] = "勾选,则为猎人的爆炸陷阱只创建一个冷却计时"
L["If checked, only show one cooldown for shaman Shocks."] = "勾选,则为萨满的震击只创建一个冷却计时"
L["If checked, only show one cooldown for paladin Crusader Strike and Hammer of the Righteous."] = "勾选,则为圣骑士的十字军打击和正义之锤只创建一个冷却计时"
L["Filter Cooldowns"] ="冷却过滤"
L["If checked, don't display any cooldowns that are in the filter list."] = "勾选,则不显示在过滤列表里的冷却"
L["If checked, only display cooldowns that are in the filter list."] = "勾选,则只显示在过滤列表里的冷却"
L["If checked, the cooldown filter list is shared with bar groups in other profiles with the same name."] = "勾选,则该列表将与配置文件中其他同名列表共享"
L["Enter Cooldown"] = "输入冷却"
L["Enter a cooldown to be added to the filter list."] = "输入一个冷却名称以加入过滤列表"
L["Delete the selected cooldown from the filter list."] = "删除选择的冷却"
L["Reset the cooldown filter list."] = "重设冷却过滤列表"
L['RESET\nAre you sure you want to reset the cooldown filter list?'] = "重设\n确定重设冷却列表?"
L["Filter cooldown bar group string"] = "勾选,则不在计时条组中显示冷却,如果选定了自定义计时条组,则不在自定义计时条组中显示冷却.如果自动选择计时条组,不显示在过滤列表里的冷却."

-- Bar Groups > Layout tab
L["Layout"] = "布局"
L["Configuration"] ="配置"
L["Bars"] = "计时条"
L["If checked, use a bar-oriented configuration."] = "勾选,则使用计时条向导配置"
L["Icons"] = "图标"
L["If checked, use an icon-oriented configuration."] =  "勾选,则使用图标向导配置"
L["Options"] = "选项"
L["Select a configuration option for bars or icons."] = "为计时条或图标选择一个配置选项"
L["Direction"] = "方向"
L["If checked, grow up or to the right, otherwise grow down or to the left."] = "勾选,则向右增长,否则向左增长"
L["Copy Layout From"] = "复制布局格式"
L["Select bar group to copy all layout settings from."] = "复制所有的布局格式"
L["Timeline"] = "时间线"
L["Width"] = "宽度"
L["Set width of timeline."] ="设置时间线的宽度"
L["Height"] = "高度"
L["Set height of timeline."] = "设置时间线的高度"
L["Set maximum duration represented on the timeline in seconds."] = "设置时间线的最大持续时间,单位秒"
L["Exponent"] = "指数"
L["Set exponent factor for timeline to adjust time scale."] = "设置时间线缩放的调节指数"
L["Label List"] = "标签列表"
L['Enter comma-separated list of times to show as labels on the timeline (times are in seconds unless you include "m", which is included in the label, or "M", which is hidden, for minutes).'] = '输入用逗号分隔的时间线中显示为标签的时间列表'
L["Texture"] = "材质"
L["Select texture for timeline."] ="选择时间线的材质"
L["Opacity"] = "透明度"
L["Set opacity for timeline."] = "设置时间线的透明度"
L["Timeline Color"] = "时间线颜色"
L["Set color for timeline background."] = "设置时间线的颜色"
L["Splash Effect"] = "闪亮效果"
L["If checked, show a splash effect when icons expire."] = "勾选,则在图标将要到期时显示闪亮效果"
L["Overlap Switch"] = "重叠开关"
L["If checked, when icons overlap, switch every two seconds which is shown on top (otherwise always show icon with shortest time remaining on top)."] = "勾选，则在时间线上重叠的图标讲轮流置于顶端."
L["Hide Empty"] ="隐藏恐怖"
L["If checked, hide the timeline background when there are no active icons."] = "勾选,则在没有图标时隐藏时间线"
L["If checked, format options are set to default values."] ="勾选,则格式选项重设到默认值"
L["Reset format for this bar group back to the current defaults."] = "重设该计时条组的配置到默认"
L["Format"] = "格式"
L["Icon"] = "图标"
L["Show icon string"] = "显示图标文字"
L["Clock"] = "时钟"
L["Show clock animation on icons for timer bars."] = "为图标显示动态时钟"
L["Bar"] = "计时条"
L["Show colored bar and background."] = "显示着色的计时条与悲剧"
L["Spark"] = "火花"
L["Show spark that moves across bars to indicate remaining time."] = "显示移动到剩余时间的火花"
L["Label"] = "标签"
L["Show label text on bars."] = "在计时条上显示标签"
L["Count"] = "层数"
L["Show stack count in parentheses after label (it is also displayed as overlay on icon)."] = "显示图标的堆叠层数"
L["Time"] ="计时器"
L["Show time left on bars that have a duration."] = "显示剩余时间"
L["Tooltips"] = "鼠标提示"
L["Show tooltips when the cursor is over a bar's icon."] = "显示鼠标提示"
L["Text Settings"] = "文字设定"
L["Label Text Inset"] = "标签文字缩进"
L["Set horizontal inset for label from edge of bar."] = "设定文字的水平缩进"
L["Label Text Offset"] = "标签文字偏移"
L["Set vertical offset for label text from center of bar."] = "设定文字的垂直偏移"
L["Wrap"] = "包裹"
L["If checked, wrap label text when it doesn't fit in the bar's width."] = "勾选,则当标签文字不适合计时条宽度时包裹文字"
L["Top"] = true
L["If checked, set \"Top\" alignment for label text."] = true
L["Middle"] = true
L["If checked, set \"Middle\" alignment for label text."] = true
L["Bottom"] = true
L["If checked, set \"Bottom\" alignment for label text."] = true
L["Time Text Inset"] = "时间文字缩进"
L["Set horizontal inset for time text from edge of bar."] = "设定时间文字的水平缩进"
L["Time Text Offset"] = "偏移"
L["Set vertical offset for time text from center of bar."] = "设定时间文字的垂直偏移"
L["If checked, use normal alignment with small inset for time and label texts."] = "勾选,则使用默认对齐"
L["Left"] = true
L["If checked, set \"Left\" alignment for time text and normal alignment for label."] = "选定,则标签文字左对齐"
L["Center"] = true
L["If checked, set \"Center\" alignment for time text and normal alignment for label."] ="选定,则标签文字中对齐"
L["Right"] = true
L["If checked, set \"Right\" alignment for time text and normal alignment for label."] = "选定,则标签文字右对齐"
L["Icon Text Inset"] ="图标文字缩进"
L["Set horizontal inset for icon text from middle of icon."] = "设置图标文字的水平缩进"
L["Icon Text Offset"] = "图标文字偏移"
L["Set vertical offset for icon text from center of icon."] = "设置图标文字的垂直偏移"
L["If checked, time text is shown on the icon instead of the bar."] = "勾选,时间文字显示在图标中间而不是计时条上"
L["Icon Configuration Options"] = "图标配置选项"
L["Set how many bars/icons to display before wrapping to next row or column. If this is set to 0 then wrapping is disabled."] = "设置每行多少计时条/图标"
L["Wrap Direction"] = "换行方向"
L["If checked, wrap up when arranged in rows or to the right when arranged in columns, otherwise wrap down or to the left."] ="勾选,则换行在左边,否则换行到右边"
L["Snap To Center"] = "捕捉中心"
L["If checked and the icon configuration bar group is locked, snap to center at the anchor position."] ="选择,则捕捉到锚点坐标中心"
L["Display Position"] = "显示位置"
L["Horizontal"] = "水平"
L["Set horizontal position as percentage of overall width (cannot move beyond edge of display)."] = "总宽度的水平位移百分比"
L["Vertical"] = "垂直"
L["Set vertical position as percentage of overall height (cannot move beyond edge of display)."] = "中高度的垂直位移百分比"
L["Bar/Icon Limit"] = "计时条/图标限制"
L["Set the maximum number of bars/icons to display (the ones that sort closest to the anchor have priority). If this is set to 0 then the number is not limited."] = "设置计时条/图标的最大数量"
L["Attachment"] = "附加"
L["Select a bar group to attach to (for independent position, attach to self)."] = "选择一个需要附加的计时条组"
L["Offset X"] = "X偏移"
L["Set horizontal offset from the selected bar group."] ="设置X偏移"
L["Offset Y"] = "Y偏移"
L["Set vertical offset from the selected bar group."] = "设置Y偏移"
L["Last Bar"] = "最后的计时条"
L["If checked, position is relative to last bar/icon in the selected bar group."] = "勾选,位置依赖于计时条组的最后一个计时条或图标"
L["Empty"] = "控"
L["If checked, offsets are not applied if the selected bar group is empty."] = "勾选,则位移在计时条组空时失效"
L["By Row"] = "行"
L["When wrap is enabled in the selected bar group, position is relative to last bar/icon in row closest to the anchor."] = "勾选,则位置依赖于计时条组/图标的最后一行"
L["By Column"] = "列"
L["When wrap is enabled in the selected bar group, position is relative to last bar/icon in column closest to the anchor."] = "勾选,则位置依赖于计时条组/图标的最后一列"
L["Parent Frame"] = "父框体"
L["Enter name of parent frame for this bar group (leave blank to use default)."] = "输入该计时条组的父框体名称"
L["Anchor Frame"] = "锚点框体"
L["Enter name of anchor frame to attach to (leave blank to enable bar group attachment)."] =  "输入该计时条组的锚点框体名称"
L["Anchor Point"] = "锚点"
L["Select point on anchor frame to attach to."] ="选择要附着的锚点"
L["Reset attachment options."] = "重设锚点"
L["Frame Stack"] = "框体层级"
L["Toggle showing Blizzard's frame stack tooltips."] = "显示系统自带的框体层级提示"

-- Bar Groups > Appearance tab
L["Appearance"] ="外观"
L["Use Defaults"] = "使用默认"
L["If checked, fonts and textures use the default values."] = "勾选,使用默认值"
L["Restore Defaults"] = "保存为默认"
L["Reset fonts and textures for this bar group back to the current defaults."] = "将当前设定保存为默认值"
L["Copy From"] = "复制格式"
L["Select bar group to copy font and texture settings from."] ="选择一个计时条组以复制格式"
L["If checked, colors use the default values."] = "使用默认颜色着色"
L["Reset standard colors for this bar group back to the current defaults."] ="重设为默认颜色"
L["Select bar group to copy standard colors from."] = "选择一个需要复制标准颜色的计时条组"
L["Bar Color Scheme"] = "计时条颜色"
L["Foreground:"] = "前景色"
L["Show bars in default colors for their type, including special debuff colors when applicable."] = "显示计时条的颜色为它们的类型颜色"
L["Color the bars with a custom color."] = "以自定义颜色着色"
L["Class Colors"] = "职业颜色"
L["Show bars in class colors of associated spells when possible, otherwise use default bar colors."] ="可用时使用职业颜色着色,否则使用默认颜色"
L["Spell Colors"] = "法术颜色"
L["Show bars using spell colors when possible, otherwise use default bar colors."] = "可用时使用法术颜色着色,否则使用默认颜色"
L["Background:"] = "背景颜色"
L["Same as Foreground"] = "和前景色相同"
L["Color the background the same as the foreground."] ="着色与前景色相同"
L["Color the background with a custom color."] ="以自定义颜色着色"
L["Icon Border:"] = "图标边框"
L["Color the icon border the same as the bar foreground."] = "着色与前景色相同"
L["Color the icon border with a custom color."] ="以自定义颜色着色"
L["Color the icon border string"] = "只为debuff添加着色边框."
L["None"] = "没有"
L["Do not color the icon border."] ="不着色图标边框"

-- Bar Groups > Timer Options tab
L["Timer Options"] = "计时器选项"
L["Show With Uniform Duration"] ="以统一的格式显示"
L["Show timer bars scaled with a uniform duration (text still shows actual time left)."] = "使用同一的计时条缩放"
L["Enter minutes in the uniform duration."] = "输入统一格式的分钟"
L["Enter seconds in the uniform duration."] = "输入统一格式的秒钟"
L["Show If Unlimited Duration"] = "无限时间时显示"
L["Show bars for actions with unlimited duration (e.g., paladin auras)."] ="无限时间时显示"
L["Only Show Unlimited"] = "只在无限时间时显示"
L["Show bars for actions only if they have unlimited duration."] ="只在无限时间时显示"
L["Full Bars"] = "完整计时条"
L["If checked, bars with unlimited duration show as full bars, otherwise they show as empty bars."] = "勾选,则持续时间无限的buff将以一个完整的计时条显示"
L["Unlimited As Zero"] = "显示为空"
L["If checked, bars with unlimited duration sort as zero duration, otherwise as very long duration."] = "勾选,则持续时间无限的buff将以一个空的计时条显示"
L["Check Overall Duration"] = "检查总持续时间"
L["Only include timer bars with a specified minimum (or maximum) duration."] = "只包括指定最小或最大值的计时条"
L["Enter minutes for overall duration check."] = "输入总持续时间的分钟"
L["Enter seconds for overall duration check."] = "输入总持续时间的秒钟"
L["Check Time Left"] = "检查剩余时间"
L["Only show timer bars with a specified minimum (or maximum) time left."] = "只显示指定了最大/最小剩余时间的计时条"
L["Enter minutes for time left check."] = "输入剩余时间的分钟"
L["Enter seconds for time left check."] = "输入剩余时间的秒钟"
L["Time Format"] = "时间格式"
L["Time format string"] = "选择计时条和图标的时间显示格式,单独设置为五个范围: " ..
	"大于一小时,2分钟到一小时,1分钟到2分钟,10秒到1分钟,小于10秒 " ..
	"这些选项可以在下拉菜单中找到示例."
L["Spaces"] = "空格"
L["Include spaces between values in time format."] = "在时间格式中包括空格"
L["Uppercase"] = "大写"
L["If checked, use uppercase H, M and S in time format, otherwise use lowercase."] = "为H,M,S使用大写"
L["Special Effects"] = "特殊效果"
L["Pulse At Start"] = "以脉冲启动"
L["Enable icon pulse when bar is started."] ="当计时条开始时以脉冲启动"
L["Pulse When Expiring"] = "将要结束时脉冲"
L["Enable icon pulse when bar is expiring."] ="当计时条结束时以脉冲启动"
L["Hide After Start"] = "开始后隐藏"
L["Enable hide after start for timer bars (does not hide bars with unlimited duration)."] = "开始后隐藏"
L["Fade After Start"] = "开始后渐隐"
L["Enable fade after start (i.e., switch to fade opacity after a delay)."] ="开始后渐隐"
L["Delay"] = "延迟"
L["Set number of seconds before bar will hide or fade."] = "开始后渐隐的延迟"
L["Flash When Expiring"] = "结束时闪烁"
L["Enable flashing of expiring bars."] = "结束时闪烁"
L["Flash Time"] = "闪烁时间"
L["Set number of seconds before expiration that bar should start flashing."] ="设置闪烁时间"

-- Conditions tab
L["Conditions"]="条件"
L["Condition"] = "条件"
L["New Condition"] = "新条件"
L["Create a new condition."] = "创建一个新条件"
L["Enter Condition Name"] = "输入条件名称"
L["Enter name of new condition."] = "输入新条件名称"
L["Cancel creating a new condition."] ="取消创建新条件"
L["Delete Condition"] = "删除条件"
L["Delete the selected condition."] = "删除选择的条件"
L["Delete condition string"] = function(name) string.format('删除条件\n确定删除"%s" 条件?', name) end

-- Conditions > General tab
L["Enable Condition"] = "启用条件"
L["If checked, the condition is enabled and its value is determined by evaluating the associated tests, otherwise the condition is disabled and its value is always false."] = true
L["Notification"] = "通知"
L["If checked, this condition is suitable for a notification and will show up as an option for new notify bars."] ="勾选,则在这种情况下是合适的通知,将显示一个新的通知栏选项"
L["Detailed Tooltip"] = "详细提示"
L["If checked, tooltip for notifications based on this condition will include a detailed description."] = "勾选,则提示将显示详细的描述"
L["Share Condition"] = "共享条件"
L["If checked, this condition's settings can be copied between characters."]  ="勾选,则条件可以在角色之间共同使用"
L["Copy Condition Settings From"] = "复制条件设置表格"
L["Select a shared condition to copy settings from, including tests, associated spells, and dependencies."] ="选择一个条件以复制"
L["Reset and delete all current shared condition settings."] = "重设并删除当前的共享条件设置"
L["Rename Condition"] = "重命名条件"
L["Enter new name for the condition."] = "输入新的条件名称"
L["Associated Spell"] = "关联法术"
L["Enter spell name (or numeric identifier) whose color and icon can be used by notification bars based on this condition."] = "输入这个条件将使用的关联法术"

-- Conditions > Tests tab
L["Tests"] = "测试"
L["Summary"] = "摘要"

-- Conditions > Tests > Player Status
L["Enable Test"] = "启用测试"
L["Enable"] = "启用"
L["If checked, enable this test."] = "勾选,启用测试"
L["Combat"] = "战斗"
L["If checked, test combat status."] = "勾选,测试战斗状态"
L["If checked, must be in combat."] = "勾选,必须在战斗中"
L["If checked, must be out of combat."] = "勾选,必须在战斗外"
L["Resting"] = "休息"
L["If checked, test if the player is resting."] = "勾选,测试玩家休息"
L["If checked, player must be resting (e.g., in an inn)."] ="勾选,玩家必须在休息状态"
L["If checked, player must not be resting."] = "勾选,玩家必须不在休息状态"
L["Mounted"] = "坐骑"
L["If checked, test if the player is mounted."] = "测试:玩家在坐骑上"
L["If checked, player must be mounted."] = "玩家必须在坐骑上"
L["If checked, player must not be mounted."] ="玩家必须不在坐骑上"
L["Stealthed"] = "潜行"
L["If checked, test if the player is stealthed."] = "测试:玩家潜行"
L["If checked, player must be stealthed."] = "玩家必须是潜行状态"
L["If checked, player must not be stealthed."] = "玩家必须不是潜行状态"
L["Fishing"] = "钓鱼"
L["If checked, test if the player is fishing."] = "测试:玩家在钓鱼"
L["If checked, player must be ready to fish (i.e., trained with fishing pole equipped)."] = "玩家必须在钓鱼"
L["If checked, player must not be ready to fish."] = "玩家必须不在钓鱼"
L["PvP"] = true
L["If checked, test if the player has PvP enabled."] = "测试:玩家处于PVP状态"
L["If checked, player must have PvP enabled."] = "玩家启用PVP"
L["If checked, player must not have PvP enabled."] = "玩家禁用PVP"
L["If checked, test if player is in a party."] = "测试:玩家在队伍里"
L["If checked, player must be in a party."] = "玩家必须在队伍里"
L["If checked, player must not be in a party."] = "玩家必须不在队伍里"
L["If checked, test if player is in raid group."] = "测试:玩家在团队里"
L["If checked, player must be in a raid group."] = "玩家必须在队伍里"
L["If checked, player must not be in a raid group."] = "玩家必须不在队伍里"
L["If checked, test if player is in either a party or raid with other players."] ="测试:玩家在队伍里或团队里"
L["If checked, player must be in either a party or raid with other players."] = "玩家必须在队伍里或团队里"
L["If checked, player must not be in either a party or raid with other players."] = "玩家必须不在队伍里或队伍里"
L["If checked, test if player is in a 5-man or raid instance."] = "测试:玩家在五人副本或团队副本里"
L["If checked, player must be in a 5-man or raid instance."] = "玩家必须在五人副本或团队副本里"
L["If checked, player must not be in a 5-man or raid instance."] = "玩家必须不在五人副本或团队副本里"
L["If checked, test if player is in an arena."] = "测试:玩家在竞技场里"
L["If checked, player must be in an arena."] = "玩家必须在竞技场里"
L["If checked, player must not be in an arena."] = "玩家必须不在竞技场"
L["If checked, test if player is in a battleground."] = "测试:玩家在战场里"
L["If checked, player must be in a battleground."] = "玩家必须在战场里"
L["If checked, player must not be in a battleground."] = "玩家必须不在战场里"
L["If checked, test if the player has a pet."] = "测试:玩家有宠物"
L["If checked, player must have a pet."] = "玩家必须有宠物"
L["If checked, player must not have a pet"] = "玩家必须没有宠物"
L["Player"] = "玩家"
L["Pet"] = "宠物"
L["Level"] = "等级"
L["If checked, test the player's level."] = "测试:玩家等级"
L["If checked, player must be at least at this level, otherwise must be lower."] = "勾选,则玩家必须高于这个等级,否则必须低于"
L["If checked, test the player's health."] ="测试:玩家生命"
L["If checked, player's health must be at least this percentage, otherwise must be less."] = "勾选,则玩家生命必须高于这个百分比,否则必须低于"
L["If checked, test the player's power (i.e., mana, rage, energy, focus, runic power)."] = "测试:玩家法力值"
L["If checked, player's power must be at least this percentage, otherwise must be less."] = "勾选,则玩家法力值必须高于这个百分比,否则必须低于"
L["If checked, test the player's holy power."] = "测试:玩家的圣能"
L["If checked, player's holy power must be at least this many charges, otherwise must be less."] = "勾选,则玩家圣能必须高于这个数字,否则必须低于"
L["If checked, test the player's number of soul shards."] = "测试:玩家的灵魂碎片"
L["If checked, player's holy power must be at least this many charges, otherwise must be less."] ="勾选,则玩家灵魂碎片必须高于这个数字,否则必须低于"
L["If checked, test the player's eclipse power. You can set power level (-100 to -1 for lunar power, 1 to 100 for solar power) and the comparison to use (either less or greater than the power level)."] = "测试：玩家月蚀能量.你可以设置基本能量进行测试"
L["If checked, player's eclipse power must be at least this level, otherwise must be less."] ="勾选,则玩家的月蚀能量必须高于这个数字,否则必须低于"
L["If checked, test the player's eclipse status. You can test current eclipse direction (toward sun or moon) and whether lunar or solar eclipse is active."] = "测试:玩家的月蚀状态"
L["If checked, player must be in Solar Eclipse."] = "勾选,则玩家必须在日蚀"
L["If checked, player must be in Lunar Eclipse."] = "勾选,则玩家必须在日蚀"
L["If checked, eclipse direction must be going toward the sun."] = "勾选,则玩家的月蚀能量必须正在向日蚀方向移动"
L["If checked, eclipse direction must be going toward the moon."] ="勾选,则玩家的日蚀能量必须正在向月蚀方向移动"
L["Available"] = "可用"
L["If checked, test the player's rune status."] ="测试:玩家符文"
L["Any"] = "任意"
L["If checked, at least one rune of any type must be available."] ="勾选,则最少一个该类型的符文必须可用"
L["If checked, must have at least one blood rune available (or enough death runes)."] = "勾选,则至少一个鲜血符文可用(或足够的死亡符文)"
L["If checked, must have at least one frost rune available (or enough death runes)."] ="勾选,则至少一个冰霜符文可用(或足够的死亡符文)"
L["If checked, must have at least one unholy rune available (or enough death runes)."] = "勾选,则至少一个邪秽符文可用(或足够的死亡符文)"
L["Recharging"] ="补充中"
L["Not Recharging"] = ",没有补充"
L[">= 1"] = true
L["If checked, test blood runes."] = "测试血符文"
L["If checked, at least one blood rune must be recharging, otherwise none."] = true
L["If checked, test frost runes."] ="测试冰霜符文"
L["If checked, at least one frost rune must be recharging, otherwise none."] = true
L["If checked, test unholy runes."] = "测试邪秽符文"
L["If checked, at least one unholy rune must be recharging, otherwise none."] = true
L["If checked, test how many combo points the player has on the target."] ="测试:连击点数"
L["If checked, player must have at least this many combo points, otherwise must be fewer."] = "勾选,玩家的连击点数必须至少有这个值,否则必须低于"
L["If checked, test the player's totem status."] = "测试:图腾状态"
L["If checked, must have an active totem of this type (or specific totem if Totem Name is defined)."] = "勾选,则玩家必须激活一个如下类型的图腾."
L["If checked, must not have an active totem of this type (or specific totem if Totem Name is defined)."] = "勾选,则玩家必须未激活一个如下类型的图腾."
L["Totem Name"] ="图腾名称"
L["Enter name of specific totem to check is active."] = "输入要监视激活的图腾名称"
L["Health"] = "生命"
L["Power"] = "法力"
L["Minimum"] = "最小"
L["Holy Power"] = "圣能"
L["Soul Shards"] = "灵魂碎片"
L["Eclipse Power"] = "月蚀能量"
L["Eclipse State"] = "月蚀状态"
L["Eclipse"] = "蚀"
L["Solar"] = "日"
L["Lunar"] = "月"
L[">> Sun"] = ">>日"
L[">> Moon"] = ">>月"
L["Combo Points"] = "连击点"
L["If checked, test if the player has a mainhand weapon equipped with at least the specified item level."] = "勾选,测试玩家的主手武器物品等级必须高于设定值"
L["If checked, test if the player has an offhand weapon equipped with at least the specified item level."] ="勾选,测试玩家的副手武器物品等级必须高于设定值"
L["If checked, test if the player has an ranged weapon equipped with at least the specified item level."] = "勾选,测试玩家的远程武器物品等级必须高于设定值"
L["If checked, test if the player is in a stance."] = "勾选,测试玩家姿态"
L['Enter the stance to check for (enter "none" to check for no stance).'] = "输入要测试的姿态"
L["If checked, test if points have been spent in one of the player's talents."] ="勾选,测试若选择的天赋已经启用"
L["Weapons"] = "武器"
L["Mainhand"] = "主手"
L["Offhand"] = "副手"
L["Ranged"] = "远程"
L["Stance"] = "姿态"
L["Talent"] = "天赋"

-- Conditions > Tests > Pet Status
L["Pet Status"] = "宠物状态"
L["If checked, test if pet currently exists."] = "如果勾选, 检测宠物当前状态."
L["If checked, pet must exist."] = "如果勾选, 则宠物必须存在."
L["If checked, pet must not exist."] = "如果勾选, 则宠物必须不存在."
L["If checked, test pet's target."] = "如果勾选, 检测宠物目标."
L["No Target"] = "无目标"
L["If checked, must not have a target."] = "如果勾选, 必须没有目标."
L["Player's Target"] = "玩家目标"
L["If checked, must be same as player's target."] = "如果勾选, 必须与玩家目标相同."
L["Any Target"] = "任何目标"
L["If checked, must have a target."] = "如果勾选, 必须拥有一个目标."
L["If checked, test the pet's health."] = "如果勾选, 检测宠物生命值."
L["If checked, pet's health must be at least this percentage, otherwise must be less."] = "如果勾选, 宠物生命值必须等于或高于此百分比, 不勾选则必须低于此百分比."
L["If checked, test the pet's power (i.e., mana, rage, energy, focus)."] = "如果勾选, 检测宠物能量值 (魔法值, 怒气值, 能量值, 集中值)."
L["If checked, pet's power must be at least this percentage, otherwise must be less."] = "如果勾选, 宠物能量值必须等于或高于此百分比, 不勾选则必须低于此百分比."

-- Conditions > Tests > Target Status
L["If checked, test if target currently exists."] = "如果勾选, 检测目标当前状态."
L["If checked, target must exist."] = "如果勾选, 则目标必须存在."
L["If checked, target must not exist."] = "如果勾选, 则目标必须不存在."
L["Player"] = "玩家"
L["If checked, test if the target is a player."] = "如果勾选, 检测目标是否为玩家目标."
L["If checked, target must be a player."] = "如果勾选, 则目标必须是玩家."
L["If checked, target must not be a player."] = "如果勾选, 则目标必须不是玩家."
L["Enemy"] = "敌方"
L["If checked, test if the target is an enemy."] = "如果勾选, 检测目标是否为敌对目标."
L["If checked, target must be an enemy."] = "如果勾选, 则目标必须是敌对目标."
L["If checked, target must not be an enemy."] = "如果勾选, 则目标必须不是敌对目标."
L["Friendly"] = "友方"
L["If checked, test if the target is friendly."] = "如果勾选, 检测目标是否为友方目标."
L["If checked, target must be friendly."] = "如果勾选, 则目标必须是友方目标."
L["If checked, target must not be friendly."] = "如果勾选, 则目标必须不是友方目标."
L["Dead"] = "死亡"
L["If checked, test if the target is dead."] = "如果勾选, 检测目标是否死亡."
L["If checked, target must be dead."] = "如果勾选, 则目标必须死亡."
L["If checked, target must not be dead."] = "如果勾选, 则目标必须存活."
L["Classification"] = "分类"
L["If checked, test the target's classification (you can select multiple classifications)."] = "如果勾选, 检测目标分类 (您可以选择多个分类)."
L["If checked, test for normal classification."] = "如果勾选, 检测正常分类."
L["If checked, test for boss classification."] = "如果勾选, 检测首领分类."
L["If checked, test for elite classification."] = "如果勾选, 检测精英分类."
L["If checked, test for rare classification."] = "如果勾选, 检测稀有分类."
L["If checked, test for rare elite classification."] = "如果勾选, 检测稀有精英分类."
L["Range"] = "距离"
L["If checked, test if the target is in range."] = "如果勾选, 检测目标距离."
L["If checked, target must be in range."] = "如果勾选, 则目标必须在射程内."
L["If checked, target must not be in range."] = "如果勾选, 则目标必须在射程外."
L["Spellsteal"] = "法术偷取"
L["Not Spellsteal"] = "不能法术偷取"
L["If checked, test for a buff that can be transferred to the player with Spellsteal."] = "如果勾选, 检测是否有可以偷取的Buff."
L["If checked, there must be a spellstealable buff."] = "如果勾选, 则必须存在可以偷取的BUFF."
L["If checked, there must not be a spellstealable buff."] = "如果勾选, 则必须没有可以偷取的BUFF."
L["If checked, test the target's health."] = "如果勾选, 检测目标生命值."
L["If checked, target's health must be at least this percentage, otherwise must be less."] = "如果勾选, 目标生命值必须等于或高于此百分比, 不勾选则必须低于此百分比."
L["If checked, test the target's power (i.e., mana, rage, energy, focus, runic power)."] = "如果勾选, 检测目标能量值 (魔法, 怒气, 能量值, 集中值, 符文能量)."
L["If checked, target's power must be at least this percentage, otherwise must be less."] = "如果勾选, 目标能量值必须等于或高于此百分比, 不勾选则必须低于此百分比."

-- Conditions > Tests > Focus Status
L["If checked, test if focus currently exists."] = "如果勾选, 检测焦点当前状态."
L["If checked, focus must exist."] = "如果勾选, 则焦点必须存在."
L["If checked, focus must not exist."] = "如果勾选, 则焦点必须不存在."
L["If checked, test if the focus is a player."] = "如果勾选, 检测焦点是否为玩家."
L["If checked, focus must be a player."] = "如果勾选, 则焦点必须是玩家."
L["If checked, focus must not be a player."] = "如果勾选, 则焦点必须不是玩家."
L["If checked, test if the focus is an enemy."] = "如果勾选, 检测焦点是否为敌对目标."
L["If checked, focus must be an enemy."] = "如果勾选, 则焦点必须是敌对目标."
L["If checked, focus must not be an enemy."] = "如果勾选, 则焦点必须不是敌对目标."
L["If checked, test if the focus is friendly."] = "如果勾选, 检测焦点是否为友方目标."
L["If checked, focus must be friendly."] = "如果勾选, 则焦点必须是友方目标."
L["If checked, focus must not be friendly."] = "如果勾选, 则焦点必须不是友方目标."
L["If checked, test if the focus is dead."] = "如果勾选, 检测焦点是否死亡."
L["If checked, focus must be dead."] = "如果勾选, 则焦点必须死亡."
L["If checked, focus must not be dead."] = "如果勾选, 则焦点必须存活."
L["If checked, test the focus's classification (you can select multiple classifications)."] = "如果勾选, 检测焦点的分类 (您可以选择多个分类)."
L["If checked, test if the focus is in range."] = "如果勾选, 检测焦点距离."
L["If checked, focus must be in range."] = "如果勾选, 则焦点必须在射程内."
L["If checked, focus must not be in range."] = "如果勾选, 则焦点必须在射程外."
L["If checked, test the focus's health."] = "如果勾选, 检测焦点生命值."
L["If checked, focus's health must be at least this percentage, otherwise must be less."] = "如果勾选, 焦点生命值必须等于或高于此百分比, 不勾选则必须低于此百分比."
L["If checked, test the focus's power (i.e., mana, rage, energy, focus, runic power)."] = "如果勾选, 检测焦点能量值 (魔法, 怒气, 能量值, 集中值, 符文能量)."
L["If checked, focus's power must be at least this percentage, otherwise must be less."] = "如果勾选, 目标焦点值必须等于或高于此百分比, 不勾选则必须低于此百分比."

-- Conditions > Tests > All Buffs
L["Buff List Entry"] = "Buff列表项"
L["Test Buffs"] = "检测Buff"
L["Who Has Buff"] = "谁拥有Buff"
L["Who Cast Buff"] = "谁施放的Buff"
L["Enter comma-separated list of buffs."] = "输入Buff列表(多个Buff可以使用逗号分隔)."
L["If checked, test if all the buffs are active."] = "如果勾选, 检测是否所有Buff都处于激活状态."
L["If checked, test if any of the buffs are not active."] = "如果勾选, 检测哪些Buff不处于激活状态."
L["If checked, test if player buffs."] = "如果勾选, 检测玩家Buff."
L["If checked, test if target buffs."] = "如果勾选, 检测目标Buff."
L["If checked, test if focus buffs."] = "如果勾选, 检测焦点Buff."
L["If checked, test if the buffs were cast by the player."] = "如果勾选, 检测玩家施放的Buff."
L["If checked, test if the buffs were cast by anyone other than the player."] = "如果勾选, 检测其他人施放的Buff."
L["If checked, buffs may be cast by anyone, including the player."] = "如果勾选, 检测所有人施放的Buff."
L["On Player"] = "存在于玩家身上"
L["On Target"] = "存在于目标身上"
L["On Focus"] = "存在于焦点身上"
L["Cast By Target"] = "目标施放的"
L["Cast By Focus"] = "焦点施放的"

-- Conditions > Tests > Any Buffs
L["If checked, test if any of the buffs are active."] = "如果勾选, 检测激活的Buff."
L["If checked, test if none of the buffs are active."] = "如果勾选, 检测未激活的Buff."

-- Conditions > Tests > Buff Time Left
L["Buff Entry"] = "Buff 项"
L["Enter the buff to be tested."] = "输入Buff进行测试."
L["Minutes"] = "分"
L["Seconds"] = "秒"
L["If checked, test if buff is on player."] = "如果勾选, 检测Buff是否存在于玩家身上."
L["If checked, test if buff is on pet."] = "如果勾选, 检测Buff是否存在于宠物身上."
L["If checked, test if buff is on target."] = "如果勾选, 检测Buff是否存在于目标身上."
L["If checked, test if buff is on focus."] = "如果勾选, 检测Buff是否存在于焦点身上."
L["If checked, test if the buff was cast by the player."] = "如果勾选, 检测玩家施放的Buff."
L["If checked, test if the buff was cast by anyone other than the player."] = "如果勾选, 检测其他人施放的Buff."
L["If checked, buff may be cast by anyone, including the player."] = "如果勾选, 检测所有人施放的Buff."

-- Conditions > Tests > Buff Count
L["Enter buff to test for stack count (if buff doesn't stack then its count is 0)."] = "输入Buff测试堆叠层数 (如果Buff无法堆叠则层数为0)."
L["Stack Count"] = "堆叠层数"
L["Enter value to compare with the buff stack count."] = "输入Buff堆叠层数比较值."
L["Comparison"] = "比较"

-- Conditions > Tests > Buff Type
L["Player Has Buff"] = "玩家的Buff"
L["If checked, player must have a mainhand buff."] = "如果勾选, 玩家必须拥有主手武器Buff."
L["If checked, player must have an offhand buff."] = "如果勾选, 玩家必须拥有副手武器Buff."
L["If checked, player must have a ranged buff."] = "如果勾选, 玩家必须拥有远程武器Buff."
L["If checked, true if player has a buff of the specified type."] = "如果勾选, 如果玩家拥有一个指定类型的Buff，则结果为正确."
L["If checked, true if player does not have a buff of the specified type."] = "如果勾选, 如果玩家未拥有一个指定类型的Buff，则结果为正确."
L["Result"] = "结果"

-- Conditions > Tests > All Debuffs
L["Debuff List Entry"] = "Debuff 列表项"
L["Test Debuffs"] = "测试Debuff"
L["Who Has Debuff"] = "谁拥有Debuff"
L["Who Cast Debuff"] = "谁施放的Debuff"
L["Enter comma-separated list of debuffs."] = "输入Debuff列表(多个Debuff可以使用逗号分隔)."
L["If checked, test if all the debuffs are active."] = "如果勾选, 检测是否所有Debuff都处于激活状态."
L["If checked, test if any of the debuffs are not active."] = "如果勾选, 检测哪些Debuff不处于激活状态."
L["If checked, test if debuff is on player."] = "如果勾选, 检测玩家Debuff."
L["If checked, test if debuff is on pet."] = "如果勾选, 检测宠物Debuff."
L["If checked, test if debuff is on target."] = "如果勾选, 检测目标Debuff."
L["If checked, test if debuff is on focus."] = "如果勾选, 检测焦点Debuff."
L["If checked, test if the debuffs were cast by the player."] = "如果勾选, 检测玩家施放的Debuff."
L["If checked, test if the debuffs were cast by anyone other than the player."] = "如果勾选, 检测其他人施放的Debuff."
L["If checked, debuffs may be cast by anyone, including the player."] = "如果勾选, 检测所有人施放的Debuff."

-- Conditions > Tests > Any Debuffs
L["If checked, test if any of the debuffs are active."] = "如果勾选, 检测激活的Debuff."
L["If checked, test if none of the debuffs are active."] = "如果勾选, 检测未激活的Debuff."

-- Conditions > Tests > Debuff Time Left
L["Enter the debuff to be tested."] = "输入Deuff进行测试."
L["Debuff Entry"] = "Debuff 项"
L["If checked, test if the debuff was cast by the player."] = "如果勾选, 检测玩家施放的Debuff."
L["If checked, test if the debuff was cast by anyone other than the player."] = "如果勾选, 检测其他人施放的Debuff."
L["If checked, debuff may be cast by anyone, including the player."] = "如果勾选, 检测所有人施放的Debuff."

-- Conditions > Tests > Debuff Count
L["Enter debuff to test for stack count (if debuff doesn't stack then its count is 0)."] = "输入Debuff测试堆叠层数 (如果Debuff无法堆叠则层数为0)."
L["Enter value to compare with the debuff stack count."] = "输入Debuff堆叠层数比较值."

-- Conditions > Tests > Debuff Type
L["Player Has Debuff"] = "玩家的Deuff"
L["If checked, player must have a poison debuff."] = "如果勾选 玩机必须拥有毒药Debuff."
L["If checked, player must have a disease debuff."] = "如果勾选 玩机必须拥有疾病Debuff."
L["If checked, player must have a curse debuff."] = "如果勾选 玩机必须拥有诅咒Debuff."
L["If checked, player must have a magic debuff."] = "如果勾选 玩机必须拥有魔法Debuff."
L["If checked, true if player has a debuff of the specified type."] = "如果勾选, 如果玩家拥有一个指定类型的Debuff，则结果为正确."
L["If checked, true if player does not have a debuff of the specified type."] = "如果勾选, 如果玩家未拥有一个指定类型的Debuff，则结果为正确."

-- Conditions > Tests > All Cooldowns
L["Spell List Entry"] = "技能列表项"
L["If checked, test if spells are usable (i.e., enough mana, reagents, etc.)."] = "如果勾选, 检测可用的技能 (例如, 拥有足够的魔法, 药剂, 等等.)."
L["Enter comma-separated list of spells."] = "输入技能列表(多个技能可以使用逗号分隔)."
L["Enter seconds for cooldown time left check."] = "输入冷却时间进行检测,单位为秒."

-- Conditions > Tests > Spell Ready
L["Spell Entry"] = "技能项"
L["Spell"] = "技能"
L["Enter spell to test if ready to be cast."] = "输入技能检测它是否可以被释放."
L["If checked, test if spell is on global cooldown, otherwise ignore global cooldown."] = "如果勾选, 则检测技能是否处于公共冷却, 如果不勾选则忽略公共冷却."
L["Is Usable"] = "可用"
L["If checked, test if spell is usable (i.e., enough mana, reagents, etc.)."] = "如果勾选, 检测法术是否可用 (例如, 拥有足够的魔法, 药剂, 等等.)."
L["If checked, also test if the target is in range of the spell."] = "如果勾选, 则同时检测目标是否处于技能射程内."
L["If checked, target must be in range."] = "如果勾选, 则目标必须处于射程内."
L["If checked, target must be out of range."] = "如果勾选, 则目标必须处于射程外."

-- Conditions > Tests > Spell Casting
L["Enter spell to test if being cast or channeled."] = "输入技能测试它是读条法术或是通道法术."
L["Who Is Casting"] = "谁施放"
L["If checked, test player casting."] = "如果勾选, 检测玩家施放."
L["If checked, test target casting."] = "如果勾选, 检测目标施放."
L["If checked, test focus casting."] = "如果勾选, 检测焦点施放."

-- Conditions > Tests > Item Ready
L["Item Entry"] = "物品记录"
L["Item"] = "物品"
L["Enter name or itemID of item to test. Item must be in the player's bags. Use generic cooldown names for Potions and Elixirs."] = "输入物品名称或ID进行测试. 物品必须在您的背包中. 使用药剂以及合剂的通用冷却名."
L["Ready"] = "就绪"
L["If checked, test if the item is ready to use."] = "如果勾选, 检测物品是否已经可以使用."
L["If checked, item must be ready."] = "如果勾选, 物品必须可以使用."
L["If checked, item must not be ready."] = "如果勾选, 物品必须不可使用."
L["If checked, test item count."] = "如果勾选, 检测物品数量."
L["Enter value to compare with item count."] = "输入物品数量参考值."
L["Charges"] = "费用"
L["If checked, test the number of charges on the item(s)."] = "如果勾选, 测试物品所需费用."
L["Enter value to compare with the number of charges."] = "输入物品所需费用的参考值."

-- Conditions > Tests > Result
L["Dependencies"] = "依赖关系"
L["Dependencies string"] = "相关在其他条件使特定的结果必须评估此条件的结果是正确的. " ..
	"一个 \"And\" 逻辑关系分组 (全部 \"And\" 依赖关系必须评估他们的指定结果) " ..
	"或者 \"Or\" (至少有一个 \"Or\" 依赖关系必须评估他们的指定结果). " ..
	"检测依赖关系前记录所有其他评估测试条件.\n"
L["True"] = "正确"
L["Condition is true only if the selected condition evaluates to true."] = "只有选择的条件被检测为正确时，条件才被判定为正确."
L["False"] = "错误"
L["Condition is true only if the selected condition evaluates to false."] = "只有选择的条件被检测为错误时，条件才被判定为错误."
L["And/Or"] = true
L["And"] = true
L["Or"] = true
L["Toggle between logical \"And\" and \"Or\" for this dependecy."] = "在 \"And\" 以及 \"Or\" 依赖关系之间切换显示."
L["Delete"] = "删除"
L["Delete this condition from the dependencies list."] = "从依赖关系列表中删除此条件."
L["Test Evaluation"] = "评估测试"
L["If checked, evaluate all enabled tests with logical \"And\" (i.e., all tests must be true), othewise use logical \"Or\" (i.e., only one test must be true)."] = "如果勾选, 评估所有启用的 \"And\" 测试 (i.e., 所有测试结果必须为正确), 否则使用 \"Or\" (i.e., 只需要一个测试结果为正确)."
L["Toggle Result"] = "显示结果"
L["If checked, the result for this condition, after evaluating all tests and checking dependencies, is toggled."] = "如果勾选, 此条件的结果, 将在所有的依赖关系检测完毕之后显示."
L["Set Result"] = "设置结果"
L["If checked, the result for this condition is set to true or false (this feature is provided to help debug conditions)."] = "如果勾选, 此条件的结果设置为正确或错误 (此功能用于调试插件)."
L["If checked, result is set to true."] = "如果勾选, 此条件的结果设置为正确."
L["If checked, result is set to false."] = "如果勾选, 此条件的结果设置为错误."

-- In-Combat Buffs tab
L["In-Combat Bar"] = "In-Combat条"
L["Enable In-Combat Bar"] = "启用In-Combat条"
L["In-combat string"] = "Raven 包含一个可选项 \"in-combat bar\" 使你可以在战斗中取消Buff. 您可以设置计时条的外观以及设置您需要取消的Buff列表. 当您选定的Buff在战斗中激活, Buff图标将在In-Combat条上显示你可以右键点击取消Buff. |cffedd400请注意:|r 您可能需要重载以应用设置.\n"
L["Enable in-combat buffs string"] = "启用显示BUFF图标的栏位，您可以在战斗中右键单击用来取消BUFF."
L["Lock Bar Layout"] = "锁定In-Combat条"
L["Lock in-combat string"] = "设置完毕后隐藏计时条."
L["Link Bar Layout"] = "连接In-Combat条"
L["Link in-combat settings string"] = "共享所有的In-Combat条设置(但不包括Buff列表)."
L["Out Of Combat"] = "脱离战斗"
L["If checked, also display buffs on the bar when out of combat."] = "如果勾选, 脱离战斗之后将依然显示Buff."
L["Enter in-combat buff string"] = "输入Buff名称将它添加到 In-Combat Buff 列表."
L["Buff List"] = "Buff列表"
L["Delete the selected buff from the in-combat list."] = "从 In-Combat Buff 列表列表中删除选择的Buff."
L["Reset the in-combat buff list."] = "重置 In-Combat Buff 列表."
L["Set size for the buff icons."] = "设置Buff图标大小."
L["Horizontal Bar"] = "横向"
L["Configure as a horizontal bar of buff icons."] = "设置Buff图标横向显示."
L["Vertical Bar"] = "纵向"
L["Configure as a vertical bar of buff icons."] = "设置Buff图标纵向显示."
L["Spacing"] = "间距"
L["Set spacing between the buff icons."] = "设置Buff图标间距."
L["Set scale factor for the bar."] = "设置In-Combat条比例."
L["Set opacity for the bar."] = "设置In-Combat条透明度."
L["Mainhand Weapon"] = "主手武器"
L["Offhand Weapon"] = "副手武器"
L["Ranged Weapon"] = "远程武器"
L["Enter name of anchor frame to attach to (leave blank to enable manual positioning)."] = "输入锚点依附框体 (如果为空白则需要手动定位)."

-- Highlights tab
L["Highlights"] = "高亮"
L["Highlights string"] = "如果您使用 Bartender4, Dominos or Macaroon 则您可以使用按钮高亮" ..
	"如果 buffs 以及 debuffs 是您施放的 (它们将要消失时将会闪烁显示). " ..
	"高亮可以出现在特定的时间并且优先级为目标-焦点-玩家. " ..
	"您还可以在按钮上显示物品以及法术的冷却计时 (如果OmniCC为加载状态，则禁用该功能).\n"
L["Enable Highlights"] = "启用高亮"
L["If checked, enable Raven's support for button highlights and cooldown counts."] = "如果勾选, 启用 Raven的按钮高亮以及冷却计时功能."
L["Use ButtonFacade"] = "使用ButtonFacade"
L["Enable setting highlights through ButtonFacade if it is loaded. This is not ideal for every BF skin which is why it can be disabled. Try both enabled and disabled settings and see which works best."] = "如果ButtonFacade被启用则通过它启用高亮设置. 并不是每个BF皮肤都能支持,这也是为什么它被禁用. "
L["Highlight Buffs"] = "Buff高亮"
L["Enable player buff highlights on buttons."] = "在按钮上启用玩家Buff高亮."
L["Buff Color"] = "Buff颜色"
L["Set player buff highlight color."] = "设置玩家Buff高亮颜色."
L["Highlight Debuffs"] = "Debuff高亮"
L["Enable player debuff highlights on buttons."] = "在按钮上启用玩家Debuff高亮."
L["Debuff Color"] = "Debuff颜色"
L["Set player debuff highlight color."] = "设置玩家Debuff高亮颜色."
L["Enable target buff highlights on buttons."] = "在按钮上启用目标Buff高亮."
L["Set target buff highlight color."] = "设置目标Buff高亮颜色."
L["Enable target debuff highlights on buttons."] = "在按钮上启用目标Debuff高亮."
L["Set target debuff highlight color."] = "设置目标Debuff高亮颜色."
L["Enable focus buff highlights on buttons."] = "在按钮上启用焦点Buff高亮."
L["Set focus buff highlight color."] = "设置焦点Buff高亮颜色."
L["Enable focus debuff highlights on buttons."] = "在按钮上启用焦点Debuff高亮."
L["Set focus debuff highlight color."] = "设置焦点Debuff高亮颜色."
L["Flashing"] = "闪烁"
L["Enable highlight flashing for expiring buffs and debuffs."] = "启用Buff/Debuff将要结束时闪烁显示."
L["Set number of seconds to flash before buffs and debuffs expire."] = "设置Buff/Debuff结束时间数值，单位为秒."
L["Cooldown Time"] = "冷却时间"
L["Show cooldown time remaining on buttons."] = "在按钮上显示剩余冷却时间."
L["Set font size for cooldown time text overlay."] = "设置冷却时间字体大小."
L["Font"] = "字体"
L["Select font for cooldown time text overlay."] = "选择冷却时间文本字体."
L["Cooldown format string"] = "选择冷却时间格式. 这里可以选择五种范围: " ..
	"大于一小时, 2分钟到1小时, 1分钟到2分钟, 10秒到1分钟, 少于10秒. " ..
	"您可以在下拉菜单中选择."
L["Alignment"] = "校准"
L["Vertical:"] = "纵向:"
L["Horizontal:"] = "横向:"
L["If checked, vertically align cooldown text to top."] = "如果勾选, 在顶部纵向排列冷却文本."
L["If checked, vertically align cooldown text in middle."] = "如果勾选, 在中部纵向排列冷却文本."
L["If checked, vertically align cooldown text to bottom."] = "如果勾选, 在底部纵向排列冷却文本."
L["If checked, horizontally align cooldown text to left."] = "如果勾选, 在左侧横向直排列冷却文本."
L["If checked, horizontally align cooldown text in center."] = "如果勾选, 在中心横向直排列冷却文本."
L["If checked, horizontally align cooldown text to right."] = "如果勾选, 在右侧横向直排列冷却文本."

-- Inserted Bar Information tab
L["Bar Information"] = "计时条信息"
L["Custom Sort Order"] = "自定义排序"
L["Move Up"] = "置顶"
L["Move the bar up, overriding sort order."] = "移动到计时条顶部."
L["Move Down"] = "下沉"
L["Move the bar down, overriding sort order."] = "移动到计时条底部."
L["If checked, enable showing the bar."] = "如果勾选, 则显示计时条."
L["Enter label text for the bar."] = "启用计时条标签文本."
L["Label Link"] = "标签关联"
L["If checked, label is linked to the associated spell and changing it here will change it for all bars linked to the same spell."] = "如果勾选, 设置标签所关联的法术以及同类法术."
L["Show When Ready"] = "准备就绪后显示"
L["If checked, show ready bar when action is not on cooldown."] = "如果勾选, 则计时条激活时表示技能不再冷却状态."
L["Show Not Active"] = "为激活时显示"
L["If checked, show ready bar when action is not active."] = "如果勾选, 则计时条激活时表示技能未激活."
L["Usable"] = "可用"
L["If checked, show ready bar only if spell is usable (i.e., enough mana, reagents, etc.)."] = "如果勾选, 则只有技能为可用时才会激活计时条 (例如拥有足够的魔法, 药剂, 等等.)."
L["Show Time"] = "显示时间"
L["Set number of seconds to show the ready bar (0 for unlimited time)."] = "设置显示计时条的时间数值.数值单位为秒 (0为最大时间)."
L["Color and Icon"] = "颜色以及图标"
L["Use Spell Color"] = "使用法术颜色"
L["If checked, use color from associated spell."] = "如果勾选, 则使用技能相关的颜色."
L["Use Spell Icon"] = "使用技能图标"
L["If checked, use icon from associated spell."] = "如果勾选, 则使用技能图标."
L["Color Link"] = "颜色关联"
L["If checked, the color is linked to the associated spell and changing it here will change it for all bars linked to the same spell."] = "如果勾选, 设置颜色所关联的法术以及同类法术."
L["Hide"] = "隐藏"
L["If checked, bar is conditionally hidden."] = "如果勾选, 计时条将有条件的隐藏."
L["If checked, bar is hidden if the condition is true."] = "如果勾选, 如果符合条件则计时条将隐藏."
L["If checked, bar is hidden if the condition is false."] = "如果勾选, 如果不符合条件则计时条将隐藏."
L["Hide Condition"] = "隐藏条件"
L["Flash"] = "闪烁"
L["If checked, bar will conditionally flash."] = "如果勾选, 计时条将有条件的闪烁."
L["If checked, bar will flash if the condition is true."] = "如果勾选, 如果符合条件则计时条将闪烁."
L["If checked, bar will flash if the condition is false."] = "如果勾选, 如果不符合条件则计时条将闪烁."
L["Flash Condition"] = "闪烁条件"
L["Fade"] = "淡化"
L["If checked, bar will conditionally change from normal opacity to fade opacity."] = "如果勾选, 计时条将有条件的从正常透明度变为淡化透明度."
L["If checked, bar will fade if the condition is true."] = "如果勾选, 如果符合条件则计时条将淡化."
L["If checked, bar will fade if the condition is false."] = "如果勾选, 如果不符合条件则计时条将淡化."
L["Fade Condition"] = "淡化条件"
L["Normal Opacity"] = "正常透明度"
L["Set normal opacity for this bar."] = "设置此计时条正常透明度."
L["Fade Opacity"] = "淡化透明度"
L["Set fade opacity for this bar."] = "设置此计时条淡化透明度."
L["Set opacity for faded bars."] = "设置淡化的计时条透明度."
L["Ready Opacity"] = "已就绪透明度"
L["Set opacity for ready bar."] = "设置已就绪的计时条透明度."
L["Type"] = "类型"
L["If checked, this is a notify bar."] = "如果勾选, 将此计时条类型设置为通告."
L["If checked, this is a buff bar."] = "如果勾选, 将此计时条类型设置为Buff."
L["If checked, this is a debuff bar."] = "如果勾选, 将此计时条类型设置为Debuff."
L["If checked, this is a cooldown bar."] = "如果勾选, 将此计时条类型设置为冷却."
L["Source"] = "来源"
L["Race"] = "种族"
L["If checked, select actions associated with a class."] = "如果勾选, 将该技能关联给一个职业."
L["If checked, select actions associated with a pet."] = "如果勾选, 将该技能关联给宠物."
L["If checked, select actions associated with a race."] = "如果勾选, 将该技能关联给一个种族."
L["If checked, enter spell name for an associated action."] = "如果勾选, 输入相关的法术名称."
L["Druid"] = "德鲁伊"
L["If checked, select druid actions."] = "如果勾选, 则选择为德鲁伊技能."
L["Hunter"] = "猎人"
L["If checked, select hunter actions."] = "如果勾选, 则选择为猎人技能."
L["Mage"] = "法师"
L["If checked, select mage actions."] = "如果勾选, 则选择为法师技能."
L["Paladin"] = "圣骑士"
L["If checked, select paladin actions."] = "如果勾选, 则选择为圣骑士技能."
L["Priest"] = "牧师"
L["If checked, select priest actions."] = "如果勾选, 则选择为牧师技能."
L["Rogue"] = "潜行者"
L["If checked, select rogue actions."] = "如果勾选, 则选择为潜行者技能."
L["Shaman"] = "萨满祭司"
L["If checked, select shaman actions."] = "如果勾选, 则选择为萨满祭司技能."
L["Warlock"] = "术士"
L["If checked, select warlock actions."] = "如果勾选, 则选择为术士技能."
L["Warrior"] = "战士"
L["If checked, select warrior actions."] = "如果勾选, 则选择为战士技能."
L["Death Knight"] = "死亡骑士"
L["If checked, select death knight actions."] = "如果勾选, 则选择为死亡骑士技能."
L["Conditions To Monitor"] = "条件检测"
L["Select all the conditions."] = "选择全部条件."
L["Deselect all the conditions."] = "反选全部条件."
L["Other Spell"] = "其他技能"
L["Enter spell name (or numeric identifier) to associate with a bar."] = "输入技能名称将它关联到计时条."
L["Actions To Monitor"] = "技能检测"
L["All On"] = "所有"
L["Select all the actions."] = "选择所有技能."
L["All Off"] = "关闭"
L["Deselect all the actions."] = "反选所有技能."
L["If checked, must be on the player."] = "如果勾选, 则必须为玩家."
L["If checked, must be on the player's pet."] = "如果勾选, 则必须为玩家宠物."
L["If checked, must be on the target."] = "如果勾选, 则必须为目标."
L["If checked, must be on the focus."] = "如果勾选, 则必须为焦点."
L["If checked, must be on the mouseover unit."] = "如果勾选, 则必须为指向单位."
L["If checked, must be on the pet's target."] = "如果勾选, 则必须为宠物目标."
L["If checked, must be on the target's target."] = "如果勾选, 则必须为目标的目标."
L["If checked, must be on the focus's target."] = "如果勾选, 则必须为焦点目标."
L["If checked, only track if cast by the player."] = "如果勾选, 则只监视玩家施放的."
L["If checked, only track if cast by the player's pet."] = "如果勾选, 则只监视玩家宠物施放的."
L["If checked, only track if cast by anyone other than the player."] = "如果勾选, 则只监视除玩家之外单位施放的."
L["If checked, track if cast by anyone, including player and pet."] = "如果勾选, 则监视所有单位施放的."
L["OK"] = "同意"
L["Confirm creating new bars for the selected actions/conditions."] = "确定为选择的技能/条件创建一个新计时条."
L["Cancel creating new bars."] = "取消创建新计时条."


L["Enrage"] = "激怒"
L["Include enrage debuffs."] = "包含激怒debuff"
L["Required Class"] = "所需职业"
L["Enter class required for internal cooldown (leave blank if all classes can trigger internal cooldown)."] = "输入触发内置CD的职业(留空则所有的职业都可以触发)"

------- New Entries September 6, 2011
L["If checked, hide count overlay text on icon."] = "如果勾选，则隐藏覆盖图标层数文字"
L["If checked, set \"Left\" alignment for icon text."] ="如果勾选，设置文本\"左对齐\""
L["If checked, set \"Center\" alignment for icon text."] = "如果勾选，设置文本\"居中对齐\""
L["If checked, set \"Right\" alignment for icon text."] = "如果勾选，设置文本\"右对齐\""
------- New Entries October 1, 2011
L["Castable"] = "可施放的"
L['Include buffs that the player can cast.'] = "包括玩家施放的Buff"
L['Include debuffs that the player can cast.'] = "包括玩家施放的Debuff"
L["NPC"] = true
L['Include buffs cast by an NPC (note: only valid while caster is selected, such as when checking target of target).'] ="包括NPC施放的Buff（注：只有当施法者被选中时有效，比如监视目标的目标）"
L['Include debuffs cast by an NPC (note: only valid while caster is selected, such as when checking target of target).'] ="包括NPC施放的DeBuff（注：只有当施法者被选中时有效，比如监视目标的目标）"
L['Include buffs cast by a vehicle (note: only valid while caster is selected, such as when checking target of target).'] = "包括载具施放的Buff（注：只有当施法者被选中时有效，比如监视目标的目标）"
L['Include debuffs cast by a vehicle (note: only valid while caster is selected, such as when checking target of target).'] = "包括载具施放的DeBUFF（注：只有当施法者被选中时有效，比如监视目标的目标）"
